package com.tiffintom.partner1.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.services_receivers.NetworkWatcher;
import com.tiffintom.partner1.utils.ToastUtils;

/**
 * Created by Amrish on 09-11-2020.
 */
public class LoginActivity extends BaseActivity {
    private MaterialButton btnLogin, btnForgotPassword, btnLogout, btnDone;
    private AppCompatEditText etEmail, etPassword;
    private LinearLayout llLoginRestaurant, llLoginPaymentService, llMainLayout;
    private TextView tvLoginRestaurant, tvLoginPaymentService, tvLoggedInMessage;
    private View vUnderLineRestaurant, vUnderLinePaymentService;
    private LinearLayout llAlreadyLoggedIn, llLoginForm;

    private LinearLayout llCountry;
    private TextView tvBack, tvCountry;
    private ImageView ivCountry;
    private boolean restaurantSelected = true;
    private LinearLayout llLoginTypeSelection;

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_login);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getIntent() != null)
            restaurantSelected = getIntent().getBooleanExtra("select_restaurant", true);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
        setListeners();
        updateDoneButton();
        if (loggedInMerchant != null) setMerchantLoggedIn();
        if (loggedInRestaurant != null) setRestaurantLoggedIn();
        if (restaurantSelected)
            selectRestaurantLogin();
        else selectPaymentService();

        try {
            new NetworkWatcher(this).observe(this, aBoolean -> {
                if (aBoolean){
                    Intent pushNotification = new Intent("NetworkChange");
                    // Toast.makeText(HomeActivity.this, "Internet Connected", Toast.LENGTH_LONG).show();
                    pushNotification.putExtra("isConnected", true);
                    LocalBroadcastManager.getInstance(LoginActivity.this).sendBroadcast(pushNotification);
                } else {
                    Intent pushNotification = new Intent("NetworkChange");
                    //  Toast.makeText(HomeActivity.this, "Internet NOT Connected", Toast.LENGTH_LONG).show();
                    pushNotification.putExtra("isConnected", false);
                    LocalBroadcastManager.getInstance(LoginActivity.this).sendBroadcast(pushNotification);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    @Override
    protected void initViews() {
        super.initViews();
        llMainLayout = findViewById(R.id.llMainLayout);
        llCountry = findViewById(R.id.llCountry);
        tvBack = findViewById(R.id.tvBack);
        tvCountry = findViewById(R.id.tvCountry);
        ivCountry = findViewById(R.id.ivCountry);

        llLoginTypeSelection = findViewById(R.id.llLoginTypeSelection);

        btnLogin = findViewById(R.id.btnLogin);
        btnForgotPassword = findViewById(R.id.btnForgotPassword);
        etEmail = findViewById(R.id.etEmail);
        etPassword = findViewById(R.id.etPassword);

        llLoginRestaurant = findViewById(R.id.llLoginRestaurant);
        tvLoginRestaurant = findViewById(R.id.tvLoginRestaurant);
        vUnderLineRestaurant = findViewById(R.id.vUnderlineRestaurant);

        llLoginPaymentService = findViewById(R.id.llLoginPaymentService);
        tvLoginPaymentService = findViewById(R.id.tvLoginPaymentService);
        vUnderLinePaymentService = findViewById(R.id.vUnderlinePaymentService);

        llAlreadyLoggedIn = findViewById(R.id.llAlreadyLoggedIn);
        llLoginForm = findViewById(R.id.llLoginForm);
        tvLoggedInMessage = findViewById(R.id.tvLoggedInMessage);
        btnLogout = findViewById(R.id.btnLogout);
        btnDone = findViewById(R.id.btnDone);

        if (loggedInRestaurant == null && loggedInMerchant == null) {
            tvBack.setVisibility(View.INVISIBLE);
        } else {
            tvBack.setVisibility(View.VISIBLE);
        }
        if (myApp.getMyPreferences().getSelectedCountry() != null) {
            tvCountry.setText(myApp.getMyPreferences().getSelectedCountry());
            if (tvCountry.getText().toString().equalsIgnoreCase("IN")) {
                ivCountry.setImageResource(R.drawable.country_india_filled);
            } else
                ivCountry.setImageResource(R.drawable.country_uk_filled);
        }
        llLoginTypeSelection.setVisibility(View.GONE);
        selectPaymentService();
    }

    private void setListeners() {
        btnLogin.setOnClickListener(view -> {
            if (isValid()) {
                CommonFunctions.hideKeyboard(this, etPassword);
                if (restaurantSelected)
                    new Thread(this::performLogin).start();
                else new Thread(this::performMerchantLogin).start();
            }
        });
        btnForgotPassword.setOnClickListener(view -> {
            startActivity(new Intent(LoginActivity.this, ForgotPasswordActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
        });
        llLoginRestaurant.setOnClickListener(view -> {
            selectRestaurantLogin();
        });
        llLoginPaymentService.setOnClickListener(view -> {
            selectPaymentService();
        });
        btnLogout.setOnClickListener(view -> {
            askForLogout();
        });
        btnDone.setOnClickListener(view -> {
            if (loggedInMerchant == null && loggedInRestaurant == null) {
                CommonFunctions.showSnackBar(this, llMainLayout, "Please login first");
            } else if (loggedInMerchant != null && myApp.getMyPreferences().getMerchantBusinesses() == null) {
                Intent intent = new Intent(this, TransportActivity.class).putExtra("destination", "restaurant_selection").putExtra("finish", true);
                startActivity(intent);
            } else if (myApp.getMyPreferences().getDefaultPrinter() == null) {
                Intent intent = new Intent(this, TransportActivity.class).putExtra("destination", "printer_selection").putExtra("finish", true);
                startActivity(intent);
            } else {
                startActivity(new Intent(this, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
            }
            etEmail.setText(null);
            etPassword.setText(null);
        });
        tvBack.setOnClickListener(view -> {
            startActivity(new Intent(this, HomeActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
        });
        llCountry.setOnClickListener(view -> startActivity(new Intent(LoginActivity.this, TransportActivity.class).putExtra("destination", "select_country").putExtra("hideToolbar", true)));
    }


    private void selectRestaurantLogin() {
        restaurantSelected = true;
        if (loggedInRestaurant == null) {
            tvLoginRestaurant.setTextColor(Color.parseColor("#707070"));
        } else {
            tvLoginRestaurant.setTextColor(ContextCompat.getColor(this, R.color.persian_green));
        }
        vUnderLineRestaurant.setVisibility(View.VISIBLE);
        vUnderLineRestaurant.setMinimumWidth(tvLoginRestaurant.getMeasuredWidth());

        if (loggedInMerchant == null)
            tvLoginPaymentService.setTextColor(Color.parseColor("#707070"));
        else {
            tvLoginPaymentService.setTextColor(ContextCompat.getColor(this, R.color.persian_green));
        }
        vUnderLinePaymentService.setVisibility(View.INVISIBLE);

        btnForgotPassword.setVisibility(View.VISIBLE);
        etEmail.setHint("Enter email");

        if (loggedInRestaurant == null) {
            llLoginForm.setVisibility(View.VISIBLE);
            llAlreadyLoggedIn.setVisibility(View.GONE);
            tvLoginRestaurant.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        } else {
            CommonFunctions.hideKeyboard(this, etEmail);
            CommonFunctions.hideKeyboard(this, etPassword);
            llLoginForm.setVisibility(View.GONE);
            llAlreadyLoggedIn.setVisibility(View.VISIBLE);
            tvLoggedInMessage.setText("You have logged in");
        }
    }

    private void selectPaymentService() {
        restaurantSelected = false;
        if (loggedInMerchant == null) {
            tvLoginPaymentService.setTextColor(Color.parseColor("#707070"));
        } else {
            tvLoginPaymentService.setTextColor(ContextCompat.getColor(this, R.color.persian_green));
        }
        vUnderLinePaymentService.setVisibility(View.VISIBLE);

        vUnderLinePaymentService.setMinimumWidth(tvLoginPaymentService.getMeasuredWidth());

        if (loggedInRestaurant == null)
            tvLoginRestaurant.setTextColor(Color.parseColor("#707070"));
        else {
            tvLoginRestaurant.setTextColor(ContextCompat.getColor(this, R.color.persian_green));
        }
        vUnderLineRestaurant.setVisibility(View.INVISIBLE);

        btnForgotPassword.setVisibility(View.GONE);
        etEmail.setHint("Enter username");

        if (loggedInMerchant == null) {
            llLoginForm.setVisibility(View.VISIBLE);
            llAlreadyLoggedIn.setVisibility(View.GONE);
            tvLoginPaymentService.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        } else {
            CommonFunctions.hideKeyboard(this, etEmail);
            CommonFunctions.hideKeyboard(this, etPassword);
            llLoginForm.setVisibility(View.GONE);
            llAlreadyLoggedIn.setVisibility(View.VISIBLE);
            tvLoggedInMessage.setText("You have logged in");
        }
    }

    private void setRestaurantLoggedIn() {
        tvLoginRestaurant.setTextColor(ContextCompat.getColor(this, R.color.persian_green));
        tvLoginRestaurant.setCompoundDrawablesWithIntrinsicBounds(null, null, ContextCompat.getDrawable(this, R.drawable.ic_baseline_green_done_24), null);
    }

    private void setMerchantLoggedIn() {
        tvLoginPaymentService.setTextColor(ContextCompat.getColor(this, R.color.persian_green));
        tvLoginPaymentService.setCompoundDrawablesWithIntrinsicBounds(null, null, ContextCompat.getDrawable(this, R.drawable.ic_baseline_green_done_24), null);
    }

    private void updateDoneButton() {
        btnDone.setEnabled(loggedInRestaurant != null || loggedInMerchant != null);

    }

    private boolean isValid() {
        etEmail.setError(null);
        etPassword.setError(null);

        if (Validators.isNullOrEmpty(etEmail.getText().toString())) {
            if (restaurantSelected)
                etEmail.setError("Please enter email");
            else etEmail.setError("Please enter username");
            etEmail.requestFocus();
            return false;
        }
        if (restaurantSelected) {

            if (!Validators.isEmail(etEmail.getText().toString())) {
                etEmail.setError("Please enter valid email");
                etEmail.requestFocus();
                return false;
            }
        }
        if (Validators.isNullOrEmpty(etPassword.getText().toString())) {
            etPassword.setError("Please enter password");
            etPassword.requestFocus();
            return false;
        }
        return true;
    }

    private void performMerchantLogin() {
        runOnUiThread(() -> progressDialog.show());
        AndroidNetworking.post(ApiEndPoints.MERCHANT_LOGIN)
                .addBodyParameter("username", etEmail.getText().toString())
                .addBodyParameter("password", etPassword.getText().toString())
                .build()
                .getAsObject(Merchant.class, new ParsedRequestListener<Merchant>() {
                    @Override
                    public void onResponse(Merchant response) {

                        ToastUtils.makeToast(LoginActivity.this, "Login successfully");
                        // myPreferences.saveEposUserPermission(new Gson().toJson(response.permissions));
                        // MyApp.userPermission = (EposUserPermission) response.permissions;
                        response.password = etPassword.getText().toString();
                        response.username = etEmail.getText().toString();
                        myApp.getMyPreferences().saveMerchant(response);
                        myApp.getMyPreferences().setSupervisorLoggedIn(true);

                        loggedInMerchant = response;
                        setMerchantLoggedIn();
                        selectPaymentService();

                        updateDoneButton();
                        btnDone.performClick();

                    }

                    @Override
                    public void onError(ANError anError) {
                        runOnUiThread(() -> progressDialog.dismiss());
                        anError.printStackTrace();
                        Log.e("anErroranError","anError "+anError.getErrorCode()+" errormsg "+anError.getMessage()+" errorbody "+anError.getErrorBody());
                        if (anError.getErrorCode() == 400) {
                            ApiError apiError = anError.getErrorAsObject(ApiError.class);
                            CommonFunctions.showSnackBar(LoginActivity.this, llMainLayout, apiError.getMessage());
                        } else {
                            CommonFunctions.showSnackBar(LoginActivity.this, llMainLayout, "Unknown Error");
                        }
                    }
                });

    }

    private void performLogin() {
        /*runOnUiThread(() -> progressDialog.show());
        AndroidNetworking.post(ApiEndPoints.BASE_URL())
                .addBodyParameter("action", "StoreLogin")
                .addBodyParameter("username", etEmail.getText().toString())
                .addBodyParameter("password", etPassword.getText().toString())
                .addBodyParameter("device_id", myApp.getMyPreferences().getUserFCMToken())
                .addBodyParameter("device_name", "Android")
                .build()
                .getAsObject(RestaurantUser.class, new ParsedRequestListener<RestaurantUser>() {
                    @Override
                    public void onResponse(RestaurantUser response) {
                        runOnUiThread(() -> progressDialog.dismiss());
                        //if (response.success.equalsIgnoreCase("1")) {
                            myApp.getMyPreferences().saveLoggedInRestaurant(response);
                            myApp.getMyPreferences().saveUserP(etPassword.getText().toString());
                            loggedInRestaurant = response;
                            setRestaurantLoggedIn();
                            selectRestaurantLogin();
                            etEmail.setText(null);
                            etPassword.setText(null);
                            updateDoneButton();
                        //} else {
                        //    CommonFunctions.showSnackBar(LoginActivity.this, llMainLayout, response.message);
                        //}
                    }

                    @Override
                    public void onError(ANError anError) {
                        runOnUiThread(() -> progressDialog.dismiss());
                        anError.printStackTrace();
                        if (!CommonFunctions.isConnected(LoginActivity.this)) {
                            myApp.noInternet(LoginActivity.this);
                        } else {
                            CommonFunctions.showSnackBar(LoginActivity.this, llMainLayout, "Unknown Error");
                        }
                    }
                });*/
    }

    private void askForLogout() {
        AlertDialog alertDialog = new AlertDialog.Builder(this).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) this.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            alertDialog.dismiss();
            myApp.stopOrderSound();
            myApp.stopDelayedOrderSound();
            myApp.stopNewMessageSound();
            myApp.logoutMerchant(LoginActivity.this, false);
            myApp.restaurantLogout(LoginActivity.this, false);
            loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
            loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
            selectPaymentService();
            updateDoneButton();
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    private void restaurantLogout() {
        myApp.stopOrderSound();
        myApp.restaurantLogout(LoginActivity.this, false);
        CommonFunctions.showSnackBar(LoginActivity.this, llMainLayout, "Restaurant Logout successfully");
        loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
        selectRestaurantLogin();
    }

    private void merchantLogout() {
        myApp.stopOrderSound();
        myApp.logoutMerchant(LoginActivity.this, false);
        CommonFunctions.showSnackBar(LoginActivity.this, llMainLayout, "Merchant Logout successfully");
        loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
        selectPaymentService();
    }


    @Override
    protected void onStop() {
        CommonFunctions.hideKeyboard(this, etPassword);
        CommonFunctions.hideKeyboard(this, etEmail);
        super.onStop();
    }

    BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (!intent.getBooleanExtra("isConnected", false)) {
                    Intent i = new Intent(LoginActivity.this, NoInternetActivity.class);
                    startActivityForResult(i, 67);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(LoginActivity.this).registerReceiver(networkChangeReceiver, new IntentFilter("NetworkChange"));
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (networkChangeReceiver != null) {
            LocalBroadcastManager.getInstance(LoginActivity.this).unregisterReceiver(networkChangeReceiver);
        }
    }
}
