package com.tiffintom.partner1.activities;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.Timer;
import java.util.TimerTask;

public class NoInternetActivity extends AppCompatActivity {

    MaterialButton btnRefresh;
    Timer timer;
    TimerTask timerTask;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_no_internet);
        try {
            btnRefresh = findViewById(R.id.btnRefresh);

            btnRefresh.setOnClickListener(view -> {
                if (CommonFunctions.isConnected(NoInternetActivity.this)) {
                    Intent returnIntent = new Intent();
                    setResult(Activity.RESULT_OK,returnIntent);
                    finish();
                }
            });
            timer = new Timer();
            startTask();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void startTask() {
        try {
            timerTask = new TimerTask() {
                @Override
                public void run() {
                    LogUtils.e("Checking connectivity....");
                    if (CommonFunctions.isConnected(NoInternetActivity.this)) {
                        LogUtils.e("Internet connected");
                        timerTask.cancel();
                        ToastUtils.makeSnackToast(NoInternetActivity.this, "Internet connection is back");
                        runOnUiThread(() -> {
                            Intent returnIntent = new Intent();
                            setResult(Activity.RESULT_OK,returnIntent);
                            finish();
                        });

                    }
                }
            };
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onStop() {
        if (timerTask != null)
            timerTask.cancel();
        super.onStop();
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            if (timerTask != null) {
                startTask();
                timer.schedule(timerTask, 10000, 2000);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}