package com.tiffintom.partner1.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.models.MerchantApp;
import com.tiffintom.partner1.models.MerchantRestaurant;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SiteSettings;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.services_receivers.NetworkWatcher;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Amrish on 30-12-2020.
 */
public class PresetupActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_presetup);
    }

    String oldRestaurantId;
    String type;
    String oldMerchantUsername;
    String oldMerchantPassword;
    String oldMerchantSelectedResId;
    String admin_islogin;
    String superviser_islogin;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        oldRestaurantId = myApp.getMyPreferences().getOldPrefValue("userid");
        type = myApp.getMyPreferences().getOldMerchantPrefValue("type"); // should be 3
        oldMerchantUsername = myApp.getMyPreferences().getOldMerchantPrefValue("username");
        oldMerchantPassword = myApp.getMyPreferences().getOldMerchantPrefValue("password");
        oldMerchantSelectedResId = myApp.getMyPreferences().getOldMerchantPrefValue("restaurantid");
        admin_islogin = myApp.getMyPreferences().getOldMerchantPrefValue("admin_islogin");
        superviser_islogin = myApp.getMyPreferences().getOldMerchantPrefValue("superviser_islogin");

        LogUtils.e("oldRestaurantId::", oldRestaurantId);
        LogUtils.e("type::", type);
        LogUtils.e("oldMerchantUsername::", oldMerchantUsername);
        LogUtils.e("oldMerchantPassword::", oldMerchantPassword);
        LogUtils.e("oldMerchantSelectedResId::", oldMerchantSelectedResId);
        LogUtils.e("admin_islogin::", admin_islogin);
        LogUtils.e("superviser_islogin::", superviser_islogin);
        if (!Validators.isNullOrEmpty(oldRestaurantId)) {
            fetchProfile(oldRestaurantId);
        } else if (!Validators.isNullOrEmpty(oldMerchantUsername) && !Validators.isNullOrEmpty(oldMerchantPassword) && !Validators.isNullOrEmpty(type) && type.equalsIgnoreCase("3")) {
            loginMerchant();
        } else {
            startActivity(new Intent(PresetupActivity.this, SplashActivity.class));
            finish();
        }

        try {
            new NetworkWatcher(this).observe(this, aBoolean -> {
                if (aBoolean){
                    Intent pushNotification = new Intent("NetworkChange");
                    // Toast.makeText(HomeActivity.this, "Internet Connected", Toast.LENGTH_LONG).show();
                    pushNotification.putExtra("isConnected", true);
                    LocalBroadcastManager.getInstance(PresetupActivity.this).sendBroadcast(pushNotification);
                } else {
                    Intent pushNotification = new Intent("NetworkChange");
                    //  Toast.makeText(HomeActivity.this, "Internet NOT Connected", Toast.LENGTH_LONG).show();
                    pushNotification.putExtra("isConnected", false);
                    LocalBroadcastManager.getInstance(PresetupActivity.this).sendBroadcast(pushNotification);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchProfile(String restaurantId) {
        try {
            LogUtils.e("FETching resturant");
            AndroidNetworking.get(ApiEndPoints.restaurants+restaurantId)
                    //.addBodyParameter("action", "StoreDetailAll")
                    //.addBodyParameter("user_id", restaurantId)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            LogUtils.e("Restaurant USER::", response.toString());
                            try {
                                if (response.getString("success").equalsIgnoreCase("1")) {
                                    myApp.getMyPreferences().saveLoggedInRestaurant(new Gson().fromJson(response.getJSONObject("getRestaurant").toString(), RestaurantUser.class));
                                    myApp.getMyPreferences().saveSiteSettings(new Gson().fromJson(response.getJSONObject("siteSettings").toString(), SiteSettings.class));
                                    if (!Validators.isNullOrEmpty(oldMerchantUsername) && !Validators.isNullOrEmpty(oldMerchantPassword)) {
                                        loginMerchant();
                                    } else {
                                        LogUtils.e("No merchant found");
                                        startActivity(new Intent(PresetupActivity.this, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                                    }
                                } else {
                                    ToastUtils.makeToast(PresetupActivity.this, response.getString("message"));
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (loggedInRestaurant == null) {
                                if (!CommonFunctions.isConnected(PresetupActivity.this)) {
                                    myApp.noInternet(PresetupActivity.this);
                                } else {
                                    ToastUtils.makeToast(PresetupActivity.this, "Unknown error");
                                }
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loginMerchant() {
        try {
            LogUtils.e("FETching merchant");
            AndroidNetworking.post(ApiEndPoints.MERCHANT_BASE_URL)
                    .addBodyParameter("username", oldMerchantUsername)
                    .addBodyParameter("password", oldMerchantPassword)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            runOnUiThread(() -> progressDialog.dismiss());
                            try {
                                if (response.getBoolean("success")) {
                                    JSONObject resultObject = response.getJSONObject("result");

                                    // Save merchant
                                    Merchant merchant = new Gson().fromJson(resultObject.toString(), Merchant.class);
                                    merchant.password = oldMerchantPassword;
                                    merchant.username = oldMerchantUsername;
                                    if (!Validators.isNullOrEmpty(oldMerchantSelectedResId)) {
                                        merchant.res_id = oldMerchantSelectedResId;
                                    }
                                    loggedInMerchant = merchant;
                                    myApp.getMyPreferences().saveMerchant(merchant);
                                    if (!Validators.isNullOrEmpty(oldMerchantSelectedResId)) {
                                        if (merchant.Restaurants != null)
                                            for (MerchantRestaurant merchantRestaurant : merchant.Restaurants) {
                                                if (merchantRestaurant.res_id.equalsIgnoreCase(oldMerchantSelectedResId)) {
                                                    myApp.getMyPreferences().saveMerchantRestaurant(merchantRestaurant);
                                                }
                                            }
                                        fetchMerchantRestaurantDetails();
                                    } else {
                                        startActivity(new Intent(PresetupActivity.this, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                                    }
                                } else {
                                    ToastUtils.makeToast(PresetupActivity.this, response.getString("result"));

                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            runOnUiThread(() -> progressDialog.dismiss());
                            anError.printStackTrace();
                            if (!CommonFunctions.isConnected(PresetupActivity.this)) {
                                myApp.noInternet(PresetupActivity.this);
                            } else {
                                ToastUtils.makeToast(PresetupActivity.this, "Unknown Error");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchMerchantRestaurantDetails() {
        try {
            AndroidNetworking.post(ApiEndPoints.MERCHANT_BASE_URL + loggedInMerchant.FunctionsName.get(0))
                    .addBodyParameter("username", oldMerchantUsername)
                    .addBodyParameter("password", oldMerchantPassword)
                    .addBodyParameter("res_id", oldMerchantSelectedResId)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            runOnUiThread(() -> progressDialog.dismiss());
                            try {
                                if (response.getBoolean("success")) {
                                    JSONObject resultObject = response.getJSONObject("result");
                                    MerchantApp merchantApp = new Gson().fromJson(resultObject.toString(), MerchantApp.class);
                                    myApp.getMyPreferences().saveMerchantAppDetails(merchantApp);

                                    if (!Validators.isNullOrEmpty(admin_islogin) && admin_islogin.equalsIgnoreCase("true")) {
                                        myApp.getMyPreferences().saveMerchantRole(2);
                                    }
                                    if (!Validators.isNullOrEmpty(superviser_islogin) && superviser_islogin.equalsIgnoreCase("true")) {
                                        myApp.getMyPreferences().saveMerchantRole(1);
                                    }
                                    startActivity(new Intent(PresetupActivity.this, SplashActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                                } else {
                                    ToastUtils.makeToast(PresetupActivity.this, response.getString("result"));
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            runOnUiThread(() -> progressDialog.dismiss());
                            anError.printStackTrace();
                            if (!CommonFunctions.isConnected(PresetupActivity.this)) {
                                myApp.noInternet(PresetupActivity.this);
                            } else {
                                ToastUtils.makeToast(PresetupActivity.this, "Unknown Error");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        LogUtils.e("USER BACK PRESS");
    }


    BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (!intent.getBooleanExtra("isConnected", false)) {
                    Intent i = new Intent(PresetupActivity.this, NoInternetActivity.class);
                    startActivityForResult(i, 67);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(PresetupActivity.this).registerReceiver(networkChangeReceiver, new IntentFilter("NetworkChange"));
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (networkChangeReceiver != null) {
            LocalBroadcastManager.getInstance(PresetupActivity.this).unregisterReceiver(networkChangeReceiver);
        }
    }
}
