package com.tiffintom.partner1.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.DeviceRegistration;
import com.tiffintom.partner1.network.ApiEndPoints;

/**
 * Created by Amrish on 07-05-2021.
 */
public class RegisterDeviceActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.dialog_register_device);
    }

    MaterialButton btnSubmit;
    EditText etDeviceName;
    TextView tvMessage;
    AlertDialog progressDialog;
    LinearLayout llMainLayout;
    boolean canRefresh;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        fetchDevice();
        setListeners();
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            progressDialog = CommonFunctions.customProgressDialog(RegisterDeviceActivity.this, "");
            llMainLayout = findViewById(R.id.llMainLayout);
            etDeviceName = findViewById(R.id.etDeviceName);
            tvMessage = findViewById(R.id.tvMessage);
            btnSubmit = findViewById(R.id.btnSubmit);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnSubmit.setOnClickListener(view -> {
                fetchDevice();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchDevice() {
        try {
            progressDialog.show();
            llMainLayout.setVisibility(View.GONE);
            AndroidNetworking.get(ApiEndPoints.devices).addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addPathParameter("device_id", myApp.getMyPreferences().getAndroidDeviceId())
                    .build()
                    .getAsObject(DeviceRegistration.class, new ParsedRequestListener<DeviceRegistration>() {
                        @Override
                        public void onResponse(DeviceRegistration response) {
                            try {
                                myApp.getMyPreferences().saveDeviceRegistration(response);
                                progressDialog.dismiss();
                                canRefresh = true;
                                if (!Validators.isNullOrEmpty(response.status) && !response.status.equalsIgnoreCase("approved")) {
                                    tvMessage.setText("Your device " + myApp.getMyPreferences().getAndroidDeviceId() + " is not approved yet, Please contact service provider to activate");
                                    etDeviceName.setVisibility(View.GONE);
                                    btnSubmit.setText("REFRESH");
                                    llMainLayout.setVisibility(View.VISIBLE);
                                } else {
                                    if (myApp.getMyPreferences().getDefaultPrinter() == null) {
                                        Intent intent = new Intent(RegisterDeviceActivity.this, TransportActivity.class).putExtra("destination", "printer_selection");
                                        startActivity(intent);
                                    } else {
                                        /*Intent intent = new Intent(RegisterDeviceActivity.this, SplashActivity.class);
                                        startActivity(intent);
                                        finish();*/
                                        Intent intent = new Intent(RegisterDeviceActivity.this, HomeActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                                        startActivity(intent);
                                        finish();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            try {
                                progressDialog.dismiss();
                                tvMessage.setText("Your device " + myApp.getMyPreferences().getAndroidDeviceId() + " is not approved yet, Please contact service provider to activate");
                                etDeviceName.setVisibility(View.GONE);
                                btnSubmit.setText("REFRESH");
                                llMainLayout.setVisibility(View.VISIBLE);
                                canRefresh = false;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
