package com.tiffintom.partner1.activities;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.firebase.remoteconfig.ConfigUpdate;
import com.google.firebase.remoteconfig.ConfigUpdateListener;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.gson.Gson;
import com.tiffintom.partner1.BuildConfig;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.fragments.Maintenance;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.CardBrandCommission;
import com.tiffintom.partner1.models.CountryCommission;
import com.tiffintom.partner1.models.DeviceRegistration;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;

public class SplashActivity extends BaseActivity {
    ImageView ivSplash;
    RelativeLayout rlMain;

    @Override
    protected void initViews() {
        super.initViews();
        try {
            ivSplash = findViewById(R.id.ivSplash);
            rlMain = findViewById(R.id.rlMain);
            Glide.with(this).load(R.drawable.splash_animation).listener(new RequestListener<Drawable>() {
                @Override
                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    return false;
                }

                @Override
                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    if (resource instanceof GifDrawable) {
                        ((GifDrawable) resource).setLoopCount(1);
                    }
                    return false;
                }
            }).into(ivSplash);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // check internet connection
        try {
            if(Validators.isNullOrEmpty(myApp.getMyPreferences().getDefaultPrinter())){
                myApp.autoSelectPrint();
            }
            if (merchantBusinesses != null) {
                myApp.connectReader(this, merchantBusinesses.id);
            }
            if (!CommonFunctions.isConnected(SplashActivity.this)) {
               /* Intent i = new Intent(SplashActivity.this, NoInternetActivity.class);
                startActivityForResult(i, 1);*/
                return;
            }

            FirebaseCrashlytics.getInstance().sendUnsentReports();
            myApp.initService();
            String oldCountry = myApp.getMyPreferences().getOldMerchantPrefValue("country");
            loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();

           /* if (Validators.isNullOrEmpty(oldCountry) && Validators.isNullOrEmpty(myApp.getMyPreferences().getSelectedCountry())) {
                Bundle bundle = new Bundle();
                bundle.putString("destination", "select_country");
                bundle.putBoolean("hideToolbar", true);
                openActivity(TransportActivity.class, bundle);
            } else {*/
               /* if (!Validators.isNullOrEmpty(oldCountry)) {
                    if (oldCountry.equalsIgnoreCase("india")) {
                        myApp.getMyPreferences().saveSelectedCountry("IN");
                    } else {
                        myApp.getMyPreferences().saveSelectedCountry("UK");
                    }
                }*/
                /*if (Validators.isNullOrEmpty(myApp.getMyPreferences().getSelectedCountry())) {
                    Bundle bundle = new Bundle();
                    bundle.putString("destination", "select_country");
                    bundle.putBoolean("hideToolbar", true);
                    openActivity(TransportActivity.class, bundle);
                } else*/
            if (loggedInMerchant == null) {
                openActivity(LoginActivity.class, null);
            } else if (myApp.getMyPreferences().getDefaultPrinter() == null) {
                Intent intent = new Intent(this, TransportActivity.class).putExtra("destination", "printer_selection").putExtra("finish", true);
                startActivity(intent);
            } else {
                handleMerchantLogin();
            }
            //}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*private void readFirebaseConfig() {
        progressDialog.show();
        FirebaseRemoteConfig mFirebaseRemoteConfig = FirebaseRemoteConfig.getInstance();
        FirebaseRemoteConfigSettings configSettings = new FirebaseRemoteConfigSettings.Builder()
                .build();
        mFirebaseRemoteConfig.setConfigSettingsAsync(configSettings);
        mFirebaseRemoteConfig.fetchAndActivate()
                .addOnCompleteListener(this, task -> {
                    if (task.isSuccessful()) {
                        boolean updated = task.getResult();
                        Log.e("remoteConfig","remoteConfig "+mFirebaseRemoteConfig.getBoolean("is_in_maintenance"));
                        if (mFirebaseRemoteConfig.getBoolean("is_in_maintenance")) {
                            FragmentTransaction ft = getSupportFragmentManager().beginTransaction();
                            ft.replace(R.id.nav_host_fragment, Maintenance.Companion.getInstance(), "Reviews");
                            ft.addToBackStack("reviews");
                            ft.commit();
                        } else {
                            navigateToNextScreen();
                        }

                    } else {
                        navigateToNextScreen();
                    }
                });
        mFirebaseRemoteConfig.addOnConfigUpdateListener(new ConfigUpdateListener() {
            @Override
            public void onUpdate(@NonNull ConfigUpdate configUpdate) {
                mFirebaseRemoteConfig.activate().addOnCompleteListener((OnCompleteListener) task -> {

                });
            }

            @Override
            public void onError(FirebaseRemoteConfigException error) {
                navigateToNextScreen();
            }
        });
    }*/

    private void handleMerchantLogin() {
        try {
            if (myApp.getMyPreferences().getMerchantBusinesses() == null) {
                Bundle bundle = new Bundle();
                bundle.putString("destination", "restaurant_selection");
                bundle.putBoolean("finish", true);
                openActivity(TransportActivity.class, bundle);
            } else {
                fetchBusinesses();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchBusinesses() {
        try {
            AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES + myApp.getMyPreferences().getBusinessId())
                    .build()
                    .getAsObject(MerchantBusinesses.class, new ParsedRequestListener<MerchantBusinesses>() {
                        @Override
                        public void onResponse(MerchantBusinesses response) {
                            try {
                                try {
                                    if (response.android_partner_app_version > Float.parseFloat(BuildConfig.VERSION_NAME)) {
                                        showAppUpdateAvailable();
                                    } else {
                                        navigateToNextScreen(response);
                                    }
                                } catch (Exception e) {
                                    navigateToNextScreen(response);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorDetail() != null && anError.getErrorDetail().toLowerCase().equalsIgnoreCase("connectionError")) {
                                    //myApp.noInternet(SplashActivity.this);
                                    ToastUtils.makeSnackToast(SplashActivity.this, "Please check your internet connection");
                                    openActivity(HomeActivity.class, getIntent().getExtras());
                                    //openActivity(NoInternetActivity.class, new Bundle());
                                } else {
                                    if (anError.getErrorCode() == 401 || anError.getErrorCode() == 403) {
                                        myApp.getMyPreferences().logoutMerchant();
                                        myApp.getMyPreferences().logout();
                                        ToastUtils.makeLongToast(SplashActivity.this, "Session expired");
                                        openActivity(SplashActivity.class, null);
                                    } else if (anError.getErrorCode() > 200) {
                                        ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                        ToastUtils.makeSnackToast(SplashActivity.this, "Something went wrong!!");
                                        // Navigate to dashboard if any API error occurs
                                        openActivity(HomeActivity.class, null);
                                    } else {
                                        if (merchantBusinesses.restaurant_id != null) {
                                            fetchRestaurantDetails(merchantBusinesses.restaurant_id);
                                        } else {
                                            validateMerchantDevice();
                                        }
                                    }
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            // Navigate to dashboard if any exception occurs at this method
            openActivity(HomeActivity.class, null);
        }
    }

    private void navigateToNextScreen(MerchantBusinesses response) {
        myApp.getMyPreferences().saveMerchantBusinesses(response);

        if (!myApp.getMyPreferences().isAdminChangedOnline()) {
            if (response.online_service) {
                myApp.getMyPreferences().saveOnlineOrderStatusAndEnable(true);
            } else
                myApp.getMyPreferences().saveOnlineOrderStatusAndEnable(false);
        }
        if (response.online_service && !Validators.isNullOrEmpty(response.restaurant_id)) {
            fetchRestaurantDetails(response.restaurant_id);
        } else {
            validateMerchantDevice();
        }
    }

    private void showAppUpdateAvailable() {
        try {
            startActivity(new Intent(this, AppVersionUpdateActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    Bundle bundleNotification = null;

    private void validateMerchantDevice() {
        try {
            bundleNotification = getIntent().getExtras();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (loggedInRestaurant != null) {
            if (!myApp.getMyPreferences().getAppIntroDone()) {
                runOnUiThread(() -> progressDialog.dismiss());
                Bundle bundle = new Bundle();
                bundle.putString("destination", "app_intro");
                bundle.putBoolean("finish", true);
                openActivity(TransportActivity.class, bundle);
            } else {
                fetchCountryBrandCommission();
            }
        } else {
            fetchCountryBrandCommission();
        }
        /*if (!progressDialog.isShowing()) {
            progressDialog.show();
        }*/
      /*  try {
            AndroidNetworking.get(ApiEndPoints.devices).addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addPathParameter("device_id", myApp.getMyPreferences().getAndroidDeviceId())
                    .build()
                    .getAsObject(DeviceRegistration.class, new ParsedRequestListener<DeviceRegistration>() {
                        @Override
                        public void onResponse(DeviceRegistration response) {
                            try {
                                myApp.getMyPreferences().saveDeviceRegistration(response);

                                if (!Validators.isNullOrEmpty(response.status) && !response.status.equalsIgnoreCase("approved")) {
                                    progressDialog.dismiss();
                                    Intent intent = new Intent(SplashActivity.this, RegisterDeviceActivity.class);
                                    startActivity(intent);
                                } else {
                                    if (loggedInRestaurant != null) {
                                        if (!myApp.getMyPreferences().getAppIntroDone()) {
                                            runOnUiThread(() -> progressDialog.dismiss());
                                            Bundle bundle = new Bundle();
                                            bundle.putString("destination", "app_intro");
                                            bundle.putBoolean("finish", true);
                                            openActivity(TransportActivity.class, bundle);
                                        } else {
                                            fetchCountryBrandCommission();
                                        }
                                    } else {
                                        fetchCountryBrandCommission();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            try {
                                progressDialog.dismiss();
                                if (anError.getErrorDetail() != null && anError.getErrorDetail().toLowerCase().equalsIgnoreCase("connectionError")) {
                                    //myApp.noInternet(SplashActivity.this);
                                    openActivity(NoInternetActivity.class, new Bundle());
                                }else{
                                    Intent intent = new Intent(SplashActivity.this, RegisterDeviceActivity.class);
                                    startActivity(intent);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    private void fetchCountryCommission() {
        try {
            AndroidNetworking.get(ApiEndPoints.businesses + "/" + myApp.getMyPreferences().getBusinessId() + "/card-brand-commissions/")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                progressDialog.dismiss();
                                ArrayList<CardBrandCommission> list = new ArrayList<>();
                                try {
                                    for (int i = 0; i < response.length(); i++) {
                                        JSONObject jsonObject = response.getJSONObject(i);
                                        CardBrandCommission cardBrandCommission = new CardBrandCommission();
                                        cardBrandCommission.id = jsonObject.getInt("id");
                                        cardBrandCommission.card_brand_id = jsonObject.getInt("card_brand_id");
                                        cardBrandCommission.business_id = jsonObject.getInt("business_id");
                                        cardBrandCommission.card_brand_id = jsonObject.getInt("card_brand_id");
                                        cardBrandCommission.stripe_percentage = jsonObject.getInt("stripe_percentage");
                                        cardBrandCommission.stripe_fixed = jsonObject.getInt("stripe_fixed");
                                        cardBrandCommission.other = jsonObject.getBoolean("other");
                                        cardBrandCommission.created_at = jsonObject.getString("created_at");
                                        JSONObject brand = jsonObject.getJSONObject("card_brand");
                                        cardBrandCommission.brand_name = brand.getString("name");
                                        list.add(cardBrandCommission);
                                    }
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                myApp.appDatabase.commissionDao().nukeCardBrandCommission();
                                myApp.appDatabase.commissionDao().insertCardBrands(list);
                                openActivity(HomeActivity.class, bundleNotification);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                progressDialog.dismiss();
                                openActivity(HomeActivity.class, bundleNotification);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            progressDialog.dismiss();
            openActivity(HomeActivity.class, bundleNotification);
        }
    }

    private void fetchCountryBrandCommission() {
        try {
            AndroidNetworking.get(ApiEndPoints.businesses + "/" + myApp.getMyPreferences().getBusinessId() + "/country-commissions/")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                myApp.appDatabase.commissionDao().nukeCountryCommission();
                                ArrayList<CountryCommission> list = new ArrayList<>();
                                try {
                                    for (int i = 0; i < response.length(); i++) {
                                        JSONObject jsonObject = response.getJSONObject(i);
                                        CountryCommission cardBrandCommission = new CountryCommission();
                                        cardBrandCommission.id = jsonObject.getInt("id");
                                        cardBrandCommission.paypal_percentage = jsonObject.getInt("paypal_percentage");
                                        cardBrandCommission.paypal_fixed = jsonObject.getInt("paypal_fixed");
                                        cardBrandCommission.stripe_percentage = jsonObject.getInt("stripe_percentage");
                                        cardBrandCommission.stripe_fixed = jsonObject.getInt("stripe_fixed");
                                        cardBrandCommission.business_id = jsonObject.getInt("business_id");
                                        cardBrandCommission.other = jsonObject.getBoolean("other");
                                        cardBrandCommission.created_at = jsonObject.getString("created_at");
                                        if (!cardBrandCommission.other) {
                                            cardBrandCommission.country_id = jsonObject.getInt("country_id");
                                            JSONObject brand = jsonObject.getJSONObject("country");
                                            cardBrandCommission.name = brand.getString("name");
                                            cardBrandCommission.iso = brand.getString("iso");
                                            cardBrandCommission.currency_code = brand.getString("currency_code");
                                        } else {
                                            cardBrandCommission.country_id = 0;
                                            cardBrandCommission.name = "";
                                            cardBrandCommission.iso = "";
                                            cardBrandCommission.currency_code = "";
                                        }
                                        list.add(cardBrandCommission);
                                    }
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                myApp.appDatabase.commissionDao().insertCountryCommissions(list);
                                fetchCountryCommission();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressDialog.dismiss();
                                fetchCountryCommission();
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            fetchCountryCommission();
            progressDialog.dismiss();
        }
    }


    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_splash);
    }

    private void fetchRestaurantDetails(String resId) {
        try {
            AndroidNetworking.get(ApiEndPoints.restaurants + resId)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                myApp.getMyPreferences().saveLoggedInRestaurant(new Gson().fromJson(response.toString(), RestaurantUser.class));
                                myApp.getMyPreferences().saveSiteSettings(myApp.getMyPreferences().getLoggedInRestaurant().site_setting);

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            validateMerchantDevice();
                        }

                        @Override
                        public void onError(ANError anError) {
                            validateMerchantDevice();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            // Navigate to dashboard if any exception occurs at this method
            openActivity(HomeActivity.class, null);
        }
    }

    private void openActivity(Class activityClass, Bundle bundle) {
        try {
            if (loggedInRestaurant != null) {
                FirebaseCrashlytics.getInstance().setCustomKey("crash_device_name", loggedInRestaurant.restaurant_name);
                FirebaseCrashlytics.getInstance().setCustomKey("crash_device_phone", loggedInRestaurant.restaurant_phone);
                FirebaseCrashlytics.getInstance().setCustomKey("crash_device_email", loggedInRestaurant.username);
                FirebaseCrashlytics.getInstance().setCustomKey("country", getResources().getConfiguration().locale.getCountry());
                FirebaseCrashlytics.getInstance().setCustomKey("build_type", BuildConfig.BUILD_TYPE);
                FirebaseCrashlytics.getInstance().setCustomKey("server", ApiEndPoints.ubsidiBuild ? "ubsidi" : "testrms");
                if (loggedInMerchant != null && loggedInMerchant.username != null) {
                    FirebaseCrashlytics.getInstance().setCustomKey("business", loggedInMerchant.username);
                }
                try {
                    FirebaseCrashlytics.getInstance().setCustomKey("first_install_at", CommonFunctions.convertMsToDesiredFormat(getPackageManager().getPackageInfo(BuildConfig.APPLICATION_ID, 0).firstInstallTime, MyApp.PHP_TIMEFORMAT));
                    FirebaseCrashlytics.getInstance().setCustomKey("last_update_at", CommonFunctions.convertMsToDesiredFormat(getPackageManager().getPackageInfo(BuildConfig.APPLICATION_ID, 0).lastUpdateTime, MyApp.PHP_TIMEFORMAT));
                } catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }

            new Handler(Objects.requireNonNull(Looper.myLooper()))
                    .postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (bundle != null)
                                startActivity(new Intent(SplashActivity.this, activityClass).putExtras(bundle).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                            else
                                startActivity(new Intent(SplashActivity.this, activityClass).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                        }
                    }, 1500);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == RESULT_OK) {
            this.recreate();
        }
    }
}