package com.tiffintom.partner1.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.view.View;
import android.view.ViewTreeObserver;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.fragments.AppInfoFragment;
import com.tiffintom.partner1.fragments.MerchantBusinessSelectionFragment;
import com.tiffintom.partner1.fragments.MerchantPrintersFragment;
import com.tiffintom.partner1.fragments.RestaurantChatWindowFragment;
import com.tiffintom.partner1.fragments.SelectCountryFragment;
import com.tiffintom.partner1.services_receivers.NetworkWatcher;

/**
 * Created by Amrish on 26-08-2020.
 */
public class TransportActivity extends BaseActivity {
    private String destination, screenName;
    private boolean hideToolbar, finish,is_from_business_change = false;
    private boolean hideBottombar, shouldGoBack = true;
    BroadcastReceiver broadcastReceiver;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        handleNavigation();

        try {
            new NetworkWatcher(this).observe(this, aBoolean -> {
                if (aBoolean){
                    Intent pushNotification = new Intent("NetworkChange");
                    pushNotification.putExtra("isConnected", true);
                    LocalBroadcastManager.getInstance(TransportActivity.this).sendBroadcast(pushNotification);
                } else {
                    Intent pushNotification = new Intent("NetworkChange");
                    pushNotification.putExtra("isConnected", false);
                    LocalBroadcastManager.getInstance(TransportActivity.this).sendBroadcast(pushNotification);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getIntent() != null) {
            destination = getIntent().getStringExtra("destination");
            is_from_business_change = getIntent().getBooleanExtra("is_from_business_change",false);
            screenName = getIntent().getStringExtra("name");
            hideToolbar = getIntent().getBooleanExtra("hideToolbar", false);
            finish = getIntent().getBooleanExtra("finish", false);
        }
    }

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_transport);
    }

    @Override
    protected void initViews() {
        super.initViews();
    }

    private void handleNavigation() {
        try {
            if (destination.equalsIgnoreCase("select_country")) {
                hideBottombar = true;
                shouldGoBack = false;
                changeFragment(SelectCountryFragment.getInstance());
            }
            if (destination.equalsIgnoreCase("app_intro")) {
                hideBottombar = true;
                shouldGoBack = true;
                changeFragment(AppInfoFragment.getInstance());
            }
            if (destination.equalsIgnoreCase("restaurant_selection")) {
                hideBottombar = true;
                shouldGoBack = true;
                if(is_from_business_change){
                    changeFragment(MerchantBusinessSelectionFragment.getInstance(true));
                }else {
                    changeFragment(MerchantBusinessSelectionFragment.getInstance());
                }
            }
            if (destination.equalsIgnoreCase("printer_selection")) {
                hideBottombar = true;
                shouldGoBack = true;
                changeFragment(MerchantPrintersFragment.getInstance());
            }
            if (destination.equalsIgnoreCase("chat")) {
                hideBottombar = true;
                shouldGoBack = true;
                changeFragment(RestaurantChatWindowFragment.getInstance());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            if (getIntent() != null) {
                fragment.setArguments(getIntent().getExtras());
            }
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flContainer, fragment);
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            findViewById(android.R.id.content).getViewTreeObserver()
                    .addOnGlobalLayoutListener(mLayoutKeyboardVisibilityListener);

            LocalBroadcastManager.getInstance(TransportActivity.this).registerReceiver(networkChangeReceiver, new IntentFilter("NetworkChange"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean mKeyboardVisible;
    private final ViewTreeObserver.OnGlobalLayoutListener mLayoutKeyboardVisibilityListener =
            () -> {
                final Rect rectangle = new Rect();
                final View contentView = this.findViewById(android.R.id.content).getRootView();
                contentView.getWindowVisibleDisplayFrame(rectangle);
                int screenHeight = contentView.getRootView().getHeight();

                // r.bottom is the position above soft keypad or device button.
                // If keypad is shown, the rectangle.bottom is smaller than that before.
                int keypadHeight = screenHeight - rectangle.bottom;
                // 0.15 ratio is perhaps enough to determine keypad height.
                boolean isKeyboardNowVisible = keypadHeight > screenHeight * 0.15;

                if (mKeyboardVisible != isKeyboardNowVisible) {
                    if (isKeyboardNowVisible) {
                        //TODO manage
                    } else {
                        //TODO manage
                    }
                }

                mKeyboardVisible = isKeyboardNowVisible;
            };


    @Override
    public void onBackPressed() {

        if (finish) {
            super.onBackPressed();
        } else {
            if (!isTaskRoot()) {
                super.onBackPressed();
            } else {
                if (shouldGoBack) {
                    finish();
                    Intent i = new Intent(this, HomeActivity.class);
                    startActivity(i);
                } else {
                    finish();
                }
            }
        }
    }

    @Override
    protected void onStop() {
        LocalBroadcastManager.getInstance(this).unregisterReceiver(broadcastReceiver);
        super.onStop();

    }

    BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (!intent.getBooleanExtra("isConnected", false)) {
                    Intent i = new Intent(TransportActivity.this, NoInternetActivity.class);
                    startActivityForResult(i, 67);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onPause() {
        super.onPause();
        if (networkChangeReceiver != null) {
            LocalBroadcastManager.getInstance(TransportActivity.this).unregisterReceiver(networkChangeReceiver);
        }
    }

}
