package com.tiffintom.partner1.activities;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseActivity;
import com.tiffintom.partner1.common.CommonFunctions;


public class WebviewActivity extends BaseActivity {

    private WebView webView;
    private String pdfUrl;
    private AlertDialog progressBarDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_webview);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getIntent() != null) {
            pdfUrl = getIntent().getStringExtra("pdfUrl");
        }
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            webView = findViewById(R.id.webView);
            progressBarDialog = CommonFunctions.customProgressDialog(this, "");

            webView.getSettings().setLoadsImagesAutomatically(true);
            webView.getSettings().setJavaScriptEnabled(true);
            webView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
            String pdf = "http://drive.google.com/viewerng/viewer?embedded=true&url=" + pdfUrl;

            webView.setWebViewClient(new WebViewClient() {
                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    progressBarDialog.show();
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    progressBarDialog.dismiss();
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    return (false);
                }
            });

            webView.loadUrl(pdf);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
