package com.tiffintom.partner1.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.fragments.AddProductBottomSheetFragment;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Allergens;

import java.util.ArrayList;

public class AllergiesitemAdapter extends RecyclerView.Adapter<AllergiesitemAdapter.AllergiesViewHolder> {

    private ArrayList<Allergens> cuisineArrayList;
    private Context activity;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public AllergiesitemAdapter(Context activity, ArrayList<Allergens> cuisineArrayList, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.activity = activity;
        this.cuisineArrayList = cuisineArrayList;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public AllergiesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AllergiesViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.allerges_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull AllergiesViewHolder holder, int position) {

        Allergens cuisine = cuisineArrayList.get(position);
        if (cuisine.isSelected) {
            holder.tvCuision.setTextColor(ContextCompat.getColor(activity, R.color.white));
            holder.cvCuision.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.eclipse_color));
        } else {
            holder.tvCuision.setTextColor(ContextCompat.getColor(activity, R.color.eclipse_color));
            holder.cvCuision.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.white));
        }

        holder.tvCuision.setText(cuisine.name);
        holder.cvCuision.setOnClickListener(view -> {
            if (!cuisine.isSelected) {
//                if (CuisineBottomSheetFragment.selectedCuisineCount >= 5) {
//                    ToastUtils.makeToast(activity, "Maximum of 5 cuisines selected");
//                } else {
                    AddProductBottomSheetFragment.selectedAllergiesCount++;
                    cuisine.isSelected = true;
                    notifyDataSetChanged();
                    if (recyclerViewItemClickListener != null) {
                        recyclerViewItemClickListener.onItemClick(position, cuisine);
                    }
                //}
            } else {
                AddProductBottomSheetFragment.selectedAllergiesCount--;
                cuisine.isSelected = false;
                notifyDataSetChanged();
                if (recyclerViewItemClickListener != null) {
                    recyclerViewItemClickListener.onItemClick(position, cuisine);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return cuisineArrayList.size();
    }

    public class AllergiesViewHolder extends RecyclerView.ViewHolder {
        private TextView tvCuision;
        private CardView cvCuision;

        public AllergiesViewHolder(@NonNull View itemView) {
            super(itemView);
            tvCuision = itemView.findViewById(R.id.tvCuisine);
            cvCuision = itemView.findViewById(R.id.cvCuisine);
        }
    }
}
