package com.tiffintom.partner1.adapters

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.cardview.widget.CardView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.tiffintom.partner1.R
import com.tiffintom.partner1.models.AppIntroModel


class AmountSelectionAdapter internal constructor(
    context: Context?,
    amountSelectionList: List<AppIntroModel>,
    var screenHeight:Int =0,
    var onItemClicked: (AppIntroModel, Int) -> Unit
) :
    RecyclerView.Adapter<AmountSelectionAdapter.ViewHolder>() {
    val amountSelectionList: List<AppIntroModel>
    private val mInflater: LayoutInflater

    // data is passed into the constructor
    init {
        mInflater = LayoutInflater.from(context)
        this.amountSelectionList = amountSelectionList
    }

    // inflates the row layout from xml when needed
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view: View = mInflater.inflate(if(screenHeight<=2100) R.layout.raw_amount_selection_medium else R.layout.raw_amount_selection, parent, false)
        return ViewHolder(view)
    }

    // binds the data to the TextView in each row
    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        if (amountSelectionList[position].isDoubleZero) {
            holder.constDouble00.visibility = View.VISIBLE
            holder.constDelete.visibility = View.GONE
            holder.cardNumber.visibility = View.GONE
            holder.txtDoubleZero.text = "00"
        } else if (amountSelectionList[position].isDelete) {
            holder.constDouble00.visibility = View.GONE
            holder.constDelete.visibility = View.VISIBLE
            holder.cardNumber.visibility = View.GONE
        } else {
            holder.txtCard.text = "${amountSelectionList[position].number}"
            holder.constDouble00.visibility = View.GONE
            holder.constDelete.visibility = View.GONE
            holder.cardNumber.visibility = View.VISIBLE
        }
        holder.cardNumber.setOnClickListener {
            onItemClicked.invoke(amountSelectionList[position], position)
        }
        holder.constDouble00.setOnClickListener {
            onItemClicked.invoke(amountSelectionList[position], position)
        }
        holder.constDelete.setOnClickListener {
            onItemClicked.invoke(amountSelectionList[position], position)
        }
    }

    // total number of rows
    override fun getItemCount(): Int {
        return amountSelectionList.size
    }

    // stores and recycles views as they are scrolled off screen
    inner class ViewHolder internal constructor(itemView: View) : RecyclerView.ViewHolder(itemView),
        View.OnClickListener {
        var txtDoubleZero: TextView
        var txtCard: TextView
        var cardNumber: CardView
        var constDelete: ConstraintLayout
        var constDouble00: ConstraintLayout

        init {
            constDouble00 = itemView.findViewById(R.id.const_double_00)
            constDelete = itemView.findViewById(R.id.const_delete)
            cardNumber = itemView.findViewById(R.id.card_number)
            txtDoubleZero = itemView.findViewById(R.id.txt_double_zero)
            txtCard = itemView.findViewById(R.id.txt_card)
            itemView.setOnClickListener(this)
        }

        override fun onClick(view: View) {

        }
    }

}