package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.models.AppInfoModel;

import java.util.ArrayList;

public class AppInfoViewPagerAdapter extends PagerAdapter {

    private LayoutInflater layoutInflater;
    private Activity activity;
    private ArrayList<AppInfoModel> infoArrayList;

    public AppInfoViewPagerAdapter(Activity activity, ArrayList<AppInfoModel> infoArrayList) {
        this.activity = activity;
        this.infoArrayList = infoArrayList;
    }

    @Override
    public int getCount() {
        return infoArrayList.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        layoutInflater = (LayoutInflater) activity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = layoutInflater.inflate(R.layout.fragment_app_info_item, null);

        AppInfoModel infoModel = infoArrayList.get(position);
        ImageView imageView = view.findViewById(R.id.ivInfo);
        TextView tvTitle = view.findViewById(R.id.tvTitle);
        TextView tvDescription = view.findViewById(R.id.tvMessage);

        tvTitle.setText(infoModel.title);
        tvDescription.setText(infoModel.description);
        imageView.setImageResource(infoModel.image);
        container.addView(view);
        return view;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        ViewPager vp = (ViewPager) container;
        View view = (View) object;
        vp.removeView(view);
    }
}
