package com.tiffintom.partner1.adapters;

import android.app.DatePickerDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.chauthai.swipereveallayout.SwipeRevealLayout;
import com.google.android.material.card.MaterialCardView;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Offer;

import java.util.ArrayList;
import java.util.Calendar;

/**
 * Created by Amrish on 14-12-2020.
 */
public class AutoDiscountAdapter extends RecyclerView.Adapter<AutoDiscountAdapter.OfferViewHolder> {
    private ArrayList<Offer> offers;
    private RecyclerViewItemClickListener offValueClickListener, orderValueClickListener, removeClickListener;
    String resId = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().id;

    public AutoDiscountAdapter(ArrayList<Offer> offers, RecyclerViewItemClickListener offValueClickListener, RecyclerViewItemClickListener orderValueClickListener, RecyclerViewItemClickListener remoewClickListener) {
        this.offers = offers;
        this.offValueClickListener = offValueClickListener;
        this.orderValueClickListener = orderValueClickListener;
        this.removeClickListener = remoewClickListener;
    }

    @NonNull
    @Override
    public OfferViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new OfferViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_autodiscount, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull OfferViewHolder holder, int position) {
        Offer offer = offers.get(position);
        offer.resid = resId;
        offer.normal = "Y";

        holder.tvOrderValue.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(offer.normal_price));
        holder.tvOffer.setText(offer.normal_percentage + "%");
        holder.tvOfferNumber.setText("Offer " + (position + 1));
        Calendar fromCalendar = Calendar.getInstance();
        Calendar toCalendar = Calendar.getInstance();

        if (!Validators.isNullOrEmpty(offer.offer_from)) {
            fromCalendar.setTime(CommonFunctions.convertStringDateToDate(offer.offer_from, "yyyy-MM-dd"));
            toCalendar.setTime(CommonFunctions.convertStringDateToDate(offer.offer_to, "yyyy-MM-dd"));
        } else {
            toCalendar.add(Calendar.DAY_OF_MONTH, +6);
        }

        holder.fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
        holder.toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

        offer.offer_from = holder.fromDate;
        offer.offer_to = holder.toDate;

        holder.tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        holder.tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));

        holder.cbDelivery.setChecked(offer.delivery_type);
        holder.cbCollection.setChecked(offer.pickup_type);
        holder.cbDinein.setChecked(offer.dinein_type);

        holder.cvOfferPercentage.setOnClickListener(view -> {
            if (offValueClickListener != null) offValueClickListener.onItemClick(position, offer);
        });
        holder.cvOrderValue.setOnClickListener(view -> {
            if (orderValueClickListener != null)
                orderValueClickListener.onItemClick(position, offer);
        });
        holder.cbDelivery.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) offer.delivery_type=true;
            else offer.delivery_type=false;
        });
        holder.cbDinein.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) offer.dinein_type=true;
            else offer.dinein_type=false;
        });
        holder.cbCollection.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) offer.pickup_type=true;
            else offer.pickup_type=false;
        });
        holder.llDelete.setOnClickListener(view -> {
            holder.swipeRevealLayout.close(true);
            offer.status =false;
            if (removeClickListener != null) removeClickListener.onItemClick(position, offer);
            offers.remove(position);
            notifyDataSetChanged();
        });
        holder.llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(holder.itemView.getContext(), (datePicker, y, m, d) -> {
                holder.fromDay = d;
                holder.fromMonth = m;
                holder.fromYear = y;
                holder.fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                fromCalendar.set(y, m, d);
                holder.tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                offer.offer_from = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(holder.toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        holder.llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(holder.itemView.getContext(), (datePicker, y, m, d) -> {
                holder.toDay = d;
                holder.toMonth = m;
                holder.toYear = y;
                holder.toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                toCalendar.set(y, m, d);
                holder.tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                offer.offer_to = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(holder.fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
    }

    @Override
    public int getItemCount() {
        return offers.size();
    }

    protected static class OfferViewHolder extends RecyclerView.ViewHolder {
        TextView tvOfferNumber, tvOffer, tvEditOffer, tvOrderValue, tvEditOrderValue;
        MaterialCardView cvOfferPercentage, cvOrderValue;
        SwipeRevealLayout swipeRevealLayout;
        LinearLayout llDelete;
        CheckBox cbDelivery, cbDinein, cbCollection;
        private TextView tvToDate, tvFromDate;
        private RelativeLayout llFromDate, llToDate;
        int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
        private String fromDate = "2019-06-01", toDate = "2020-12-31";

        public OfferViewHolder(@NonNull View itemView) {
            super(itemView);
            tvOfferNumber = itemView.findViewById(R.id.tvOfferNumber);
            swipeRevealLayout = itemView.findViewById(R.id.swipeRevealLayout);
            tvOffer = itemView.findViewById(R.id.tvOfferPercentage);
            tvOrderValue = itemView.findViewById(R.id.tvOrderValue);

            cbCollection = itemView.findViewById(R.id.cbCollection);
            cbDelivery = itemView.findViewById(R.id.cbDelivery);
            cbDinein = itemView.findViewById(R.id.cbDinein);

            cvOfferPercentage = itemView.findViewById(R.id.cvOfferPercentage);
            cvOrderValue = itemView.findViewById(R.id.cvOrderValue);

            tvToDate = itemView.findViewById(R.id.tvToDate);
            tvFromDate = itemView.findViewById(R.id.tvFromDate);
            llToDate = itemView.findViewById(R.id.llToDate);
            llFromDate = itemView.findViewById(R.id.llFromDate);

            llDelete = itemView.findViewById(R.id.llDelete);
        }
    }
}
