package com.tiffintom.partner1.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.chauthai.swipereveallayout.SwipeRevealLayout;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Addon;
import com.tiffintom.partner1.models.Categories;
import com.tiffintom.partner1.models.Product;

import java.util.ArrayList;

public class CategoryAdapter extends RecyclerView.Adapter<CategoryAdapter.ViewHolder> {

    private ArrayList<Object> feed;
    private RecyclerViewItemClickListener itemViewClickListener, removeClickListener, activeInActiveListener;

    public CategoryAdapter(ArrayList<Object> categories, RecyclerViewItemClickListener itemViewClickListener, RecyclerViewItemClickListener removeClickListener, RecyclerViewItemClickListener activeInActiveListener) {
        this.feed = categories;
        this.itemViewClickListener = itemViewClickListener;
        this.removeClickListener = removeClickListener;
        this.activeInActiveListener = activeInActiveListener;
    }

    @NonNull
    @Override
    public CategoryAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_menu_items_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CategoryAdapter.ViewHolder holder, int position) {
        if (feed.get(position) instanceof Categories) {
            Categories category = (Categories) feed.get(position);
            holder.tvCategoryName.setText(category.category_name);

            Context context = holder.itemView.getContext();
            holder.switchActiveInActive.setChecked(category.status.equalsIgnoreCase("true"));
            if (category.status.equalsIgnoreCase("true")) {
                holder.tvStatus.setText("Active");
                holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
            } else {
                holder.tvStatus.setText("Inactive");
                holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.reject_color));

            }
            holder.llMenu.setOnClickListener(view -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(position, category);
                }
            });
            holder.llDelete.setOnClickListener(view -> {
                holder.swipeRevealLayout.close(true);
                if (removeClickListener != null)
                    removeClickListener.onItemClick(position, category);
                feed.remove(position);
                notifyDataSetChanged();
            });
            holder.tvEditDelete.setOnClickListener(view -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(position, category);
                }
            });
            holder.switchActiveInActive.setOnCheckedChangeListener((compoundButton, b) -> {
                if (activeInActiveListener != null && compoundButton.isPressed()) {
                    activeInActiveListener.onItemClick(position, category);
                    if (category.status.equalsIgnoreCase("true")) {
                        holder.tvStatus.setText("Inactive");
                        holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.reject_color));
                    } else {
                        holder.tvStatus.setText("Active");
                        holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
                    }
                }
            });
        } else if (feed.get(position) instanceof Addon) {
            Addon addon = (Addon) feed.get(position);
            holder.tvCategoryName.setText(addon.mainaddons_name);
            holder.tvSubName.setVisibility(View.VISIBLE);
            holder.tvSubName.setText(addon.category_name);

            Context context = holder.itemView.getContext();
            holder.switchActiveInActive.setChecked(addon.status.equalsIgnoreCase("true"));
            if (addon.status.equalsIgnoreCase("true")) {
                holder.tvStatus.setText("Active");
                holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
            } else {
                holder.tvStatus.setText("Inactive");
                holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.reject_color));

            }
            holder.llDelete.setOnClickListener(view -> {
                holder.swipeRevealLayout.close(true);
                if (removeClickListener != null) removeClickListener.onItemClick(position, addon);
                feed.remove(position);
                notifyDataSetChanged();
            });
            holder.tvEditDelete.setOnClickListener(view -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(position, addon);
                }
            });
            holder.llMenu.setOnClickListener(view -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(position, addon);
                }
            });
            holder.switchActiveInActive.setOnCheckedChangeListener((compoundButton, b) -> {
                if (activeInActiveListener != null && compoundButton.isPressed()) {
                    activeInActiveListener.onItemClick(position, addon);
                    if (addon.status.equalsIgnoreCase("true")) {
                        holder.tvStatus.setText("Inactive");
                        holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.reject_color));
                    } else {
                        holder.tvStatus.setText("Active");
                        holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
                    }
                }
            });
        } else if (feed.get(position) instanceof Product) {
            Product product = (Product) feed.get(position);
            holder.tvCategoryName.setText(product.menu_name);
            holder.tvSubName.setVisibility(View.VISIBLE);
            holder.tvSubName.setText(product.category_name);

            Context context = holder.itemView.getContext();
            holder.switchActiveInActive.setChecked(product.status.equalsIgnoreCase("true"));
            if (product.status.equalsIgnoreCase("true")) {
                holder.tvStatus.setText("Active");
                holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
            } else {
                holder.tvStatus.setText("Inactive");
                holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.reject_color));

            }
            holder.llDelete.setOnClickListener(view -> {
                holder.swipeRevealLayout.close(true);
                if (removeClickListener != null) removeClickListener.onItemClick(position, product);
                feed.remove(position);
                notifyDataSetChanged();
            });
            holder.llMenu.setOnClickListener(view -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(position, product);
                }
            });
            holder.tvEditDelete.setOnClickListener(view -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(position, product);
                }
            });
            holder.switchActiveInActive.setOnCheckedChangeListener((compoundButton, b) -> {
                if (activeInActiveListener != null && compoundButton.isPressed()) {
                    activeInActiveListener.onItemClick(position, product);
                    if (product.status.equalsIgnoreCase("true")) {
                        holder.tvStatus.setText("Inactive");
                        holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.reject_color));
                    } else {
                        holder.tvStatus.setText("Active");
                        holder.tvStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
                    }
                }
            });
        }

    }

    @Override
    public int getItemCount() {
        return feed.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvSubName, tvCategoryName, tvEditDelete, tvStatus;
        SwipeRevealLayout swipeRevealLayout;
        LinearLayout llDelete, llMenu;
        SwitchCompat switchActiveInActive;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvSubName = itemView.findViewById(R.id.tvSubName);
            tvCategoryName = itemView.findViewById(R.id.tvCategoryName);
            tvEditDelete = itemView.findViewById(R.id.tvEditDelete);
            tvStatus = itemView.findViewById(R.id.tvStatus);
            swipeRevealLayout = itemView.findViewById(R.id.swipeRevealLayout);
            llDelete = itemView.findViewById(R.id.llDelete);
            llMenu = itemView.findViewById(R.id.llMenu);
            switchActiveInActive = itemView.findViewById(R.id.switchActiveInActive);
        }
    }
}
