package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.models.Categories;

import java.util.ArrayList;
import java.util.List;

public class CategoryAutoSuggestedAdapter extends ArrayAdapter<Categories> {

    List<Categories> items, tempItems, suggestions;
    private Activity activity;

    public CategoryAutoSuggestedAdapter(@NonNull Activity context, List<Categories> items) {
        super(context, 0, items);
        this.activity = context;
        this.items = items;
        tempItems = new ArrayList<Categories>(items); // this makes the difference.
        suggestions = new ArrayList<Categories>();
    }

    public void updateData(List<Categories> items) {
        this.items = items;
        tempItems = new ArrayList<Categories>(items); // this makes the difference.
        if (activity != null) {
            activity.runOnUiThread(this::notifyDataSetChanged);
        }
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.custom_auto_text_layout, parent, false);
        }
        TextView tvCustomer = convertView.findViewById(R.id.tvCategoryName);

        Categories customer = items.get(position);
        tvCustomer.setText(customer.category_name);
        return convertView;
    }

    @NonNull
    @Override
    public Filter getFilter() {
        return nameFilter;
    }

    Filter nameFilter = new Filter() {
        @Override
        public CharSequence convertResultToString(Object resultValue) {
            String str = ((Categories) resultValue).category_name;
            return str;
        }

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {
            if (activity != null) {
                activity.runOnUiThread(() -> {

                });
            }
            if (constraint != null) {
                suggestions.clear();
                int count = 0;
                for (Categories categories : tempItems) {
                    if ((categories.category_name != null && categories.category_name.toLowerCase().contains(constraint.toString().toLowerCase()))) {
                        suggestions.add(categories);
                        count++;
                        if (count == 25) {
                            break;
                        }
                    }
                }
                FilterResults filterResults = new FilterResults();
                filterResults.values = suggestions;
                filterResults.count = suggestions.size();
                return filterResults;
            } else {
                return new FilterResults();
            }
        }

        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            if (activity != null) {
                activity.runOnUiThread(() -> {
                    List<Categories> filterList = (ArrayList<Categories>) results.values;
                    if (results != null && results.count > 0) {
                        clear();
                        addAll(filterList);
                        notifyDataSetChanged();
                    }

                });
            }
        }
    };
}
