package com.tiffintom.partner1.adapters;

import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.CaxTonBankTransactionModel;
import com.tiffintom.partner1.models.CaxTonTransactionListModel;

import java.util.ArrayList;

public class CaxTonBankTransactionAdapter extends RecyclerView.Adapter<CaxTonBankTransactionAdapter.CaxTonTransactioListViewHolder> {
    private ArrayList<CaxTonBankTransactionModel> caxTonBankTransactionModels;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public void notifyList(ArrayList<CaxTonBankTransactionModel> caxTonBankTransactionModels) {
        this.caxTonBankTransactionModels = caxTonBankTransactionModels;
        notifyDataSetChanged();
    }

    public CaxTonBankTransactionAdapter(ArrayList<CaxTonBankTransactionModel> caxTonBankTransactionModels, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.caxTonBankTransactionModels = caxTonBankTransactionModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonTransactioListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonTransactioListViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_caxton_transaction, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonTransactioListViewHolder holder, int position) {

        CaxTonBankTransactionModel caxTonCardListModel = caxTonBankTransactionModels.get(position);
        /*if(caxTonCardListModel.debit_amount!=null && Float.parseFloat(caxTonCardListModel.debit_amount)>0){
            holder.tvAmount.setTextColor(ContextCompat.getColor(holder.itemView.getContext(),R.color.red_));
            holder.tvAmount.setText("£"+caxTonCardListModel.debit_amount);
        }else if(caxTonCardListModel.credit_amount!=null && Float.parseFloat(caxTonCardListModel.credit_amount)>0){
            holder.tvAmount.setTextColor(ContextCompat.getColor(holder.itemView.getContext(),R.color.green));
            holder.tvAmount.setText("£"+caxTonCardListModel.credit_amount);
        }else {
            holder.tvAmount.setTextColor(Color.BLACK);
            holder.tvAmount.setText("£0.00");
        }*/
        String currencySymbol = MyApp.getInstance().currencySymbol;
        if (caxTonCardListModel.amount != null && Float.parseFloat(caxTonCardListModel.amount) < 0) {
           /* Spannable word = new SpannableString(currencySymbol+caxTonCardListModel.amount.replace("-",""));
            word.setSpan(ContextCompat.getColor(holder.tvAmount.getContext(),R.color.red_), 0, word.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);*/
            holder.tvAmount.setTextColor(ContextCompat.getColor(holder.tvAmount.getContext(),R.color.black));
            String amount ="";
            if(!Validators.isNullOrEmpty(caxTonCardListModel.amount)){
                amount = MyApp.df.format(Float.parseFloat(caxTonCardListModel.amount.replace("-","").replace(",","")));
                currencySymbol = currencySymbol+amount;
                holder.tvAmount.setText(currencySymbol);
            }
           /* Spannable wordTwo = new SpannableString("\n Bal :- "+ currencySymbol+caxTonCardListModel.total_balance);

            wordTwo.setSpan(ContextCompat.getColor(holder.tvAmount.getContext(),R.color.black), 0, wordTwo.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            holder.tvAmount.append(wordTwo);*/
        }else {
            holder.tvAmount.setTextColor(ContextCompat.getColor(holder.tvAmount.getContext(),R.color.black));
            //Spannable word = new SpannableString(caxTonCardListModel.amount.replace("-",""));
            //word.setSpan(ContextCompat.getColor(holder.tvAmount.getContext(),R.color.green), 0, word.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            String amount ="";
            if(!Validators.isNullOrEmpty(caxTonCardListModel.amount)){
                amount = MyApp.df.format(Float.parseFloat(caxTonCardListModel.amount.replace("-","").replace(",","")));
                currencySymbol = currencySymbol+amount;
                holder.tvAmount.setText(currencySymbol);
            }
            /*Spannable wordTwo = new SpannableString("\n Bal :- "+caxTonCardListModel.total_balance);

            wordTwo.setSpan(ContextCompat.getColor(holder.tvAmount.getContext(),R.color.black), 0, wordTwo.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            holder.tvAmount.append(wordTwo);*/
        }
        if(caxTonCardListModel.caxTonBeneficiaresModel!=null){
            holder.tvDescription.setText(caxTonCardListModel.caxTonBeneficiaresModel.name);
        }
        holder.tvDate.setText(caxTonCardListModel.status);
        //Log.e("tvCategorytvCategory", "tvCategory " + CommonFunctions.formatUnknownDateTime(caxTonCardListModel.transaction_date, "yyyy-MM-dd'T'hh:mm:ss.Z", "dd-MM-yyyy hh:mm a"));
        holder.tvCategory.setText(CommonFunctions.formatUnknownDateTime(caxTonCardListModel.transaction_date, "yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "dd-MM-yyyy hh:mm a"));
        holder.itemView.getRootView().setOnClickListener(view -> {
            notifyDataSetChanged();
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonCardListModel);
            }
        });
    }

    @Override
    public int getItemCount() {
        return caxTonBankTransactionModels.size();
    }

    public static class CaxTonTransactioListViewHolder extends RecyclerView.ViewHolder {
        private TextView tvDescription, tvCategory, tvAmount,tvDate;

        public CaxTonTransactioListViewHolder(@NonNull View itemView) {
            super(itemView);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvDescription = itemView.findViewById(R.id.tvDescription);
            tvCategory = itemView.findViewById(R.id.tvCategory);
        }
    }
}
