package com.tiffintom.partner1.adapters;

import static com.tiffintom.partner1.utils.Constants.DELETE_CLICKED;
import static com.tiffintom.partner1.utils.Constants.EDIT_CLICKED;
import static com.tiffintom.partner1.utils.Constants.ITEM_CLICKED;
import static com.tiffintom.partner1.utils.Constants.TRANSFER_CLICKED;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListenerName;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.CaxTonBeneficiaresModel;

import java.util.ArrayList;

public class CaxTonBeneficiariesAdapter extends RecyclerView.Adapter<CaxTonBeneficiariesAdapter.CaxTonTransactioListViewHolder> {
    private ArrayList<CaxTonBeneficiaresModel> caxTonBeneficiariesResponseModels;
    private RecyclerItemViewClickListenerName recyclerViewItemClickListener;

    public void notifyList(ArrayList<CaxTonBeneficiaresModel> caxTonCardListModels){
        this.caxTonBeneficiariesResponseModels = caxTonCardListModels;
        notifyDataSetChanged();
    }
    public CaxTonBeneficiariesAdapter(ArrayList<CaxTonBeneficiaresModel> caxTonBeneficiariesResponseModels, RecyclerItemViewClickListenerName recyclerViewItemClickListener) {
        this.caxTonBeneficiariesResponseModels = caxTonBeneficiariesResponseModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonTransactioListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonTransactioListViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_caxton_beneficiares, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonTransactioListViewHolder holder, int position) {

        CaxTonBeneficiaresModel caxTonBeneficiariesResponseModel = caxTonBeneficiariesResponseModels.get(position);
        holder.tvBeneficiaresName.setText(caxTonBeneficiariesResponseModel.name);
        holder.tvAccountNumber.setText(caxTonBeneficiariesResponseModel.account_number);
        holder.tvSortCode.setText(caxTonBeneficiariesResponseModel.sortCode);
        holder.itemView.getRootView().setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonBeneficiariesResponseModel,ITEM_CLICKED);
            }
        });
        holder.tvEdit.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonBeneficiariesResponseModel,EDIT_CLICKED);
            }
        });
        holder.tvDelete.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonBeneficiariesResponseModel,DELETE_CLICKED);
            }
        });
        holder.tvTransfer.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonBeneficiariesResponseModel,TRANSFER_CLICKED);
            }
        });
    }

    @Override
    public int getItemCount() {
        return caxTonBeneficiariesResponseModels.size();
    }

    public static class CaxTonTransactioListViewHolder extends RecyclerView.ViewHolder {
        private TextView tvBeneficiaresName, tvAccountNumber,tvSortCode,tvTransfer,tvEdit,tvDelete;

        public CaxTonTransactioListViewHolder(@NonNull View itemView) {
            super(itemView);
            tvDelete = itemView.findViewById(R.id.tvDelete);
            tvEdit = itemView.findViewById(R.id.tvEdit);
            tvTransfer = itemView.findViewById(R.id.tvTransfer);
            tvSortCode = itemView.findViewById(R.id.tvSortCode);
            tvBeneficiaresName = itemView.findViewById(R.id.tvBeneficiaresName);
            tvAccountNumber = itemView.findViewById(R.id.tvAccountNumber);
        }
    }
}
