package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.CaxTonCardListModel;

import java.util.ArrayList;

public class CaxTonCardListAdapter extends RecyclerView.Adapter<CaxTonCardListAdapter.CaxTonCardListViewHolder> {
    private ArrayList<CaxTonCardListModel> caxTonCardListModels;
    private boolean isFromAllCard;
    private RecyclerViewItemClickListener recyclerViewItemClickListener, getPinItemClickListener, blockCardItemClickListener;

    public void notifyList(ArrayList<CaxTonCardListModel> caxTonCardListModels) {
        this.caxTonCardListModels = caxTonCardListModels;
        notifyDataSetChanged();
    }

    public CaxTonCardListAdapter(boolean isFromAllCard,ArrayList<CaxTonCardListModel> caxTonCardListModels, RecyclerViewItemClickListener recyclerViewItemClickListener, RecyclerViewItemClickListener getPinItemClickListener
            , RecyclerViewItemClickListener blockCardItemClickListener) {
        this.isFromAllCard = isFromAllCard;
        this.caxTonCardListModels = caxTonCardListModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
        this.getPinItemClickListener = getPinItemClickListener;
        this.blockCardItemClickListener = blockCardItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonCardListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonCardListViewHolder(LayoutInflater.from(parent.getContext()).inflate(isFromAllCard ?R.layout.item_caxton_card_view : R.layout.item_caxton_card, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonCardListViewHolder holder, int position) {

        CaxTonCardListModel caxTonCardListModel = caxTonCardListModels.get(position);
        holder.tvCardName.setText(caxTonCardListModel.card_holder_name);
        holder.tvCardNumber.setText("XXXX-" + caxTonCardListModel.card_number);
        if(isFromAllCard){
            if(caxTonCardListModel.expiry!=null && caxTonCardListModel.expiry.trim().length()==4){
                String first2 = firstTwo(caxTonCardListModel.expiry.trim());
                String last2 = caxTonCardListModel.expiry.trim().substring(Math.max(caxTonCardListModel.expiry.trim().length() - 2, 0));

                holder.tvCardExpiry.setText(first2+"/"+last2);
            }else{
                holder.tvCardExpiry.setText(caxTonCardListModel.expiry.trim());
            }
        }
        if (caxTonCardListModel.card_state.equalsIgnoreCase("Active")) {
            holder.tvBlock.setText("Freeze");
        } else if (caxTonCardListModel.card_state.equalsIgnoreCase("Blocked")) {
            holder.tvBlock.setText("UNBLOCK");
        }
        holder.tvBlock.setOnClickListener(view -> {
            if (blockCardItemClickListener != null) {
                blockCardItemClickListener.onItemClick(position, caxTonCardListModel);
            }
        });
        holder.tvGetPin.setOnClickListener(view -> {
            if (getPinItemClickListener != null) {
                getPinItemClickListener.onItemClick(position, caxTonCardListModel);
            }
        });
        holder.itemView.getRootView().setOnClickListener(view -> {
            notifyDataSetChanged();
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonCardListModel);
            }
        });
    }

    public String firstTwo(String str) {
        return str.length() < 2 ? str : str.substring(0, 2);
    }

    @Override
    public int getItemCount() {
        return caxTonCardListModels.size();
    }

    public static class CaxTonCardListViewHolder extends RecyclerView.ViewHolder {
        private TextView tvCardName, tvCardNumber, tvGetPin, tvBlock,tvCardExpiry;

        public CaxTonCardListViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBlock = itemView.findViewById(R.id.tvBlock);
            tvCardExpiry = itemView.findViewById(R.id.tvCardExpiry);
            tvGetPin = itemView.findViewById(R.id.tvGetPin);
            tvCardName = itemView.findViewById(R.id.tvCardName);
            tvCardNumber = itemView.findViewById(R.id.tvCardNumber);
        }
    }
}
