package com.tiffintom.partner1.adapters;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.CaxTonTransactionListModel;

import java.util.ArrayList;

public class CaxTonRecentTransactionAdapter extends RecyclerView.Adapter<CaxTonRecentTransactionAdapter.CaxTonTransactioListViewHolder> {
    private boolean isFromPendingTrans= false;
    private boolean isFromUbsidiWallet= false;
    private ArrayList<CaxTonTransactionListModel> caxTonTransactionListModels;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public void notifyList(ArrayList<CaxTonTransactionListModel> caxTonCardListModels){
        this.caxTonTransactionListModels = caxTonCardListModels;
        notifyDataSetChanged();
    }

    public void notifyList(ArrayList<CaxTonTransactionListModel> caxTonCardListModels,boolean isFromUbsidiWallet){
        this.isFromUbsidiWallet = isFromUbsidiWallet;
        this.caxTonTransactionListModels = caxTonCardListModels;
        notifyDataSetChanged();
    }
    public CaxTonRecentTransactionAdapter(ArrayList<CaxTonTransactionListModel> caxTonCardListModels, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.caxTonTransactionListModels = caxTonCardListModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    public CaxTonRecentTransactionAdapter(ArrayList<CaxTonTransactionListModel> caxTonCardListModels,boolean isFromPendingTrans, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.isFromPendingTrans = isFromPendingTrans;
        this.caxTonTransactionListModels = caxTonCardListModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonTransactioListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonTransactioListViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_caxton_transaction, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonTransactioListViewHolder holder, int position) {

        CaxTonTransactionListModel caxTonCardListModel = caxTonTransactionListModels.get(position);
        if(isFromPendingTrans){
            holder.tvAmount.setTextColor(Color.BLACK);
            holder.tvAmount.setText("£"+caxTonCardListModel.amount);
        }else {
            if(caxTonCardListModel.debit_amount!=null && Float.parseFloat(caxTonCardListModel.debit_amount)>0){
                holder.tvAmount.setTextColor(ContextCompat.getColor(holder.itemView.getContext(),R.color.red_));
                holder.tvAmount.setText("£"+caxTonCardListModel.debit_amount);
            }else if(caxTonCardListModel.credit_amount!=null && Float.parseFloat(caxTonCardListModel.credit_amount)>0){
                holder.tvAmount.setTextColor(ContextCompat.getColor(holder.itemView.getContext(),R.color.green));
                holder.tvAmount.setText("£"+caxTonCardListModel.credit_amount);
            }else {
                holder.tvAmount.setTextColor(Color.BLACK);
                holder.tvAmount.setText("£0.00");
            }
        }
        //holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(caxTonCardListModel.transaction_date, "yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "dd-MM-yyyy hh:mm a"));
        if(isFromPendingTrans){
            holder.tvCategory.setVisibility(View.VISIBLE);
            if(caxTonCardListModel.caxTonBeneficiaresModel!=null && !Validators.isNullOrEmpty(caxTonCardListModel.caxTonBeneficiaresModel.name)){
                holder.tvCategory.setText(caxTonCardListModel.caxTonBeneficiaresModel.name);
            }else if(caxTonCardListModel.walletListModel!=null && !Validators.isNullOrEmpty(caxTonCardListModel.walletListModel.name)){
                holder.tvCategory.setText(caxTonCardListModel.walletListModel.name);
            }else {
                holder.tvCategory.setVisibility(View.GONE);
            }
            holder.tvDescription.setTextColor(ContextCompat.getColor(holder.itemView.getContext(),R.color.red_));
            holder.tvDescription.setText(caxTonCardListModel.status);
            holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(caxTonCardListModel.created_at, "yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "dd-MM-yyyy hh:mm a"));
        }else {
            holder.tvDescription.setText(caxTonCardListModel.description);
            holder.tvCategory.setText(caxTonCardListModel.transaction_category);
            if(isFromUbsidiWallet){
                holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(caxTonCardListModel.created_at, "yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "dd-MM-yyyy hh:mm a"));
            }else {
                holder.tvDate.setText(caxTonCardListModel.transaction_date);
            }
        }
        holder.itemView.getRootView().setOnClickListener(view -> {
            notifyDataSetChanged();
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonCardListModel);
            }
        });
    }

    @Override
    public int getItemCount() {
        return caxTonTransactionListModels.size();
    }

    public static class CaxTonTransactioListViewHolder extends RecyclerView.ViewHolder {
        private TextView tvDescription, tvCategory,tvAmount,tvDate;

        public CaxTonTransactioListViewHolder(@NonNull View itemView) {
            super(itemView);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvDescription = itemView.findViewById(R.id.tvDescription);
            tvCategory = itemView.findViewById(R.id.tvCategory);
        }
    }
}
