package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.WalletListModel;

import java.util.ArrayList;

public class CaxTonSelectWalletListAdapter extends RecyclerView.Adapter<CaxTonSelectWalletListAdapter.CaxTonCardListViewHolder> {
    private ArrayList<WalletListModel> walletListModels;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;
    private boolean isFromLoadWallet;
    public ArrayList<WalletListModel> getList(){
       return this.walletListModels;
    }
    public void notifyList(ArrayList<WalletListModel> walletListModels){
        this.walletListModels = walletListModels;
        notifyDataSetChanged();
    }
    public CaxTonSelectWalletListAdapter(boolean isFromLoadWallet,ArrayList<WalletListModel> walletListModels, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.isFromLoadWallet = isFromLoadWallet;
        this.walletListModels = walletListModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonCardListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonCardListViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_select_caxton_wallet_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonCardListViewHolder holder, int position) {

        WalletListModel walletListModel = walletListModels.get(position);
        holder.rdWalletName.setText(walletListModel.name);
        holder.rdWalletName.setChecked(walletListModel.isShowPassword);
        holder.rdWalletName.setOnCheckedChangeListener((compoundButton, b) -> {
            if (recyclerViewItemClickListener != null && compoundButton.isPressed()) {
                walletListModel.isShowPassword = b;
                recyclerViewItemClickListener.onItemClick(position, walletListModel);
            }
        });
        holder.txt_available_balance_value.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                walletListModel.isShowPassword = !walletListModel.isShowPassword;
                recyclerViewItemClickListener.onItemClick(position, walletListModel);
            }
        });
        if(isFromLoadWallet){
            if(!Validators.isNullOrEmpty(walletListModel.balance)){
                holder. txt_available_balance_value.setText(walletListModel.balance);
            }
            holder. txt_available_balance_value.setVisibility(View.VISIBLE);
        }else {
            holder. txt_available_balance_value.setVisibility(View.GONE);
        }
           /*     .setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, walletListModel);
            }
        });*/
    }

    @Override
    public int getItemCount() {
        return walletListModels.size();
    }

    public static class CaxTonCardListViewHolder extends RecyclerView.ViewHolder {
        private RadioButton rdWalletName;
        private TextView txt_available_balance_value;
        public CaxTonCardListViewHolder(@NonNull View itemView) {
            super(itemView);
            txt_available_balance_value = itemView.findViewById(R.id.txt_available_balance_value);
            rdWalletName = itemView.findViewById(R.id.rdWalletName);
        }
    }
}
