package com.tiffintom.partner1.adapters;

import static com.tiffintom.partner1.utils.Constants.DELETE_CLICKED;
import static com.tiffintom.partner1.utils.Constants.EDIT_CLICKED;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListenerName;
import com.tiffintom.partner1.models.CaxTonStandingInstructionModel;

import java.util.ArrayList;

public class CaxTonStandingInstructionsAdapter extends RecyclerView.Adapter<CaxTonStandingInstructionsAdapter.CaxTonTransactioListViewHolder> {
    private ArrayList<CaxTonStandingInstructionModel> caxTonBankTransactionModels;
    private Boolean isFromList;
    private RecyclerItemViewClickListenerName recyclerViewItemClickListener;

    public void notifyList(ArrayList<CaxTonStandingInstructionModel> caxTonBankTransactionModels) {
        this.caxTonBankTransactionModels = caxTonBankTransactionModels;
        notifyDataSetChanged();
    }

    public CaxTonStandingInstructionsAdapter(ArrayList<CaxTonStandingInstructionModel> caxTonBankTransactionModels,boolean isFromList, RecyclerItemViewClickListenerName recyclerViewItemClickListener) {
        this.isFromList = isFromList;
        this.caxTonBankTransactionModels = caxTonBankTransactionModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonTransactioListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonTransactioListViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_standing_instruction, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonTransactioListViewHolder holder, int position) {

        CaxTonStandingInstructionModel caxTonStandingInstructionModel = caxTonBankTransactionModels.get(position);
        holder.tvBeneficiaresName.setText(caxTonStandingInstructionModel.beneficiary_name);
        holder.tvAmount.setText(MyApp.getInstance().currencySymbol+""+caxTonStandingInstructionModel.amount);
        holder.tvExpiryDate.setText(caxTonStandingInstructionModel.expiry_date);
        if(isFromList){
            holder.tvEdit.setVisibility(View.VISIBLE);
        }else{
            holder.tvEdit.setVisibility(View.GONE);
        }
        holder.tvEdit.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonStandingInstructionModel,EDIT_CLICKED);
            }
        });
        holder.tvDelete.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonStandingInstructionModel,DELETE_CLICKED);
            }
        });
        holder.itemView.getRootView().setOnClickListener(view -> {
            notifyDataSetChanged();
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, caxTonStandingInstructionModel,"");
            }
        });
    }

    @Override
    public int getItemCount() {
        return caxTonBankTransactionModels.size();
    }

    public static class CaxTonTransactioListViewHolder extends RecyclerView.ViewHolder {
        private TextView tvExpiryDate, tvAmount,tvBeneficiaresName,tvEdit,tvDelete;

        public CaxTonTransactioListViewHolder(@NonNull View itemView) {
            super(itemView);
            tvDelete = itemView.findViewById(R.id.tvDelete);
            tvEdit = itemView.findViewById(R.id.tvEdit);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvBeneficiaresName = itemView.findViewById(R.id.tvBeneficiaresName);
            tvExpiryDate = itemView.findViewById(R.id.tvExpiryDate);
        }
    }
}
