package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.WalletListModel;

import java.util.ArrayList;

public class CaxTonWalletListAdapter extends RecyclerView.Adapter<CaxTonWalletListAdapter.CaxTonCardListViewHolder> {
    private ArrayList<WalletListModel> walletListModels;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;
    public ArrayList<WalletListModel> getList(){
       return this.walletListModels;
    }
    public void notifyList(ArrayList<WalletListModel> walletListModels){
        this.walletListModels = walletListModels;
        notifyDataSetChanged();
    }
    public CaxTonWalletListAdapter(ArrayList<WalletListModel> walletListModels, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.walletListModels = walletListModels;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CaxTonCardListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CaxTonCardListViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_caxton_wallet_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CaxTonCardListViewHolder holder, int position) {

        WalletListModel walletListModel = walletListModels.get(position);
        holder.tvWalletName.setText(walletListModel.name);
        //holder.tvWalletId.setText(walletListModel.wallet_id);
        if(walletListModel.isShowPassword){
            holder.img_show_hide.setImageResource(R.mipmap.ic_show_password);
            holder.tvLifeTimeBalance.setText("£"+walletListModel.use_limit);
        }else {
            holder.img_show_hide.setImageResource(R.mipmap.ic_hide_password);
            holder.tvLifeTimeBalance.setText(holder.tvLifeTimeBalance.getContext().getString(R.string.xxxxx));
        }
        holder.img_show_hide.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, null);
            }
        });
        holder.itemView.getRootView().setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null) {
                recyclerViewItemClickListener.onItemClick(position, walletListModel);
            }
        });
    }

    @Override
    public int getItemCount() {
        return walletListModels.size();
    }

    public static class CaxTonCardListViewHolder extends RecyclerView.ViewHolder {
        private TextView tvWalletName, tvWalletId,tvLifeTimeBalance;
        private ImageView img_show_hide;
        public CaxTonCardListViewHolder(@NonNull View itemView) {
            super(itemView);
            img_show_hide = itemView.findViewById(R.id.img_show_hide);
            tvWalletName = itemView.findViewById(R.id.tvWalletName);
            tvWalletId = itemView.findViewById(R.id.tvWalletId);
            tvLifeTimeBalance = itemView.findViewById(R.id.tvAmount);
        }
    }
}
