package com.tiffintom.partner1.adapters;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatSeekBar;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Dategroup;
import com.tiffintom.partner1.models.Message;
import com.tiffintom.partner1.models.RestaurantUser;

import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by Amrish on 12-09-2020.
 */
public class ChatAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements StickHeaderItemDecoration.StickyHeaderInterface {
    private ArrayList<Object> objects;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;
    private RestaurantUser loggedInUser = MyApp.getInstance().getMyPreferences().getLoggedInRestaurant();
    private String customerImage;
    private boolean tiffintomChat = false;

    public ChatAdapter(ArrayList<Object> objects, RecyclerViewItemClickListener recyclerViewItemClickListener, String customerImage) {
        this.objects = objects;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
        this.customerImage = customerImage;
    }

    public ChatAdapter(ArrayList<Object> objects, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.objects = objects;
        this.tiffintomChat = true;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        if (viewType == R.layout.item_chat_message_nonowner || viewType == R.layout.item_chat_message_owner) {
            return new MessageViewHolder(view);
        } else if (viewType == R.layout.item_chat_image_message_owner || viewType == R.layout.item_chat_image_message_nonowner) {
            return new ChatImageMessageViewHolder(view);
        } else if (viewType == R.layout.item_chat_audio_message_owner || viewType == R.layout.item_chat_audio_message_nonowner) {
            return new ChatAudioViewHolder(view);
        } else if (viewType == R.layout.item_chat_date_group) {
            return new ChatDateGroupViewHolder(view);
        }
        return null;
    }

    @Override
    public int getItemViewType(int position) {
        if (objects.get(position) instanceof Message) {
            Message m = (Message) objects.get(position);
            if (m.is_attach == 1) {
                if (m.admin == 1) {
                    return R.layout.item_chat_image_message_owner;
                } else
                    return R.layout.item_chat_image_message_nonowner;
            } else if (m.is_attach == 2) {
                if (m.admin == 1) {
                    return R.layout.item_chat_audio_message_owner;
                } else
                    return R.layout.item_chat_audio_message_nonowner;
            } else {
                if (m.admin == 1)
                    return R.layout.item_chat_message_owner;
                else return R.layout.item_chat_message_nonowner;
            }
        } else if (objects.get(position) instanceof Dategroup) {
            return R.layout.item_chat_date_group;
        }

        return super.getItemViewType(position);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {

        try {
            if (getItemViewType(position) == R.layout.item_chat_message_nonowner || getItemViewType(position) == R.layout.item_chat_message_owner) {
                MessageViewHolder holder = (MessageViewHolder) viewHolder;
                Message message = (Message) objects.get(position);
                holder.tvMessage.setText(message.message);

                if (!Validators.isNullOrEmpty(message.created)) {
                    holder.tvMessageTime.setText(CommonFunctions.formatUnknownDateTime(message.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                } else {
                    holder.tvMessageTime.setText("");
                }
                String logo = "";
                if (message.admin == 1 && !Validators.isNullOrEmpty(loggedInUser.logo_name)) {
                    logo = loggedInUser.logo_name;
                } else if (message.admin == 0 && !Validators.isNullOrEmpty(customerImage)) {
                    logo = customerImage;
                }
            }


            if (getItemViewType(position) == R.layout.item_chat_image_message_owner || getItemViewType(position) == R.layout.item_chat_image_message_nonowner) {
                Context context = viewHolder.itemView.getContext();
                Message message = (Message) objects.get(position);
                ChatImageMessageViewHolder holder = (ChatImageMessageViewHolder) viewHolder;
                if (message.is_attach == 1) {
                    holder.ivMessage.setVisibility(View.VISIBLE);
                    Glide.with(context).load(message.image_url).placeholder(R.drawable.banner_placeholder).error(R.drawable.banner_placeholder).into(holder.ivMessage);
                } else {
                    holder.ivMessage.setVisibility(View.GONE);
                }

                if (!Validators.isNullOrEmpty(message.created)) {
                    holder.tvMessageTime.setText(CommonFunctions.formatUnknownDateTime(message.created,  MyApp.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                } else {
                    holder.tvMessageTime.setText("");
                }
                String logo = "";
                if (message.admin == 1 && !Validators.isNullOrEmpty(loggedInUser.logo_name)) {
                    logo = loggedInUser.logo_name;
                } else if (message.admin == 0 && !Validators.isNullOrEmpty(customerImage)) {
                    logo = customerImage;
                }
            }
            if (getItemViewType(position) == R.layout.item_chat_audio_message_owner || getItemViewType(position) == R.layout.item_chat_audio_message_nonowner) {
                Message message = (Message) objects.get(position);
                ChatAudioViewHolder holder = (ChatAudioViewHolder) viewHolder;

                Handler mSeekbarUpdateHandler = new Handler();
                Runnable mUpdateSeekbar = new Runnable() {
                    @Override
                    public void run() {
                        try {
                            if (holder.mPlayer != null && holder.mPlayer.isPlaying()) {
                                holder.seekBar.setProgress(holder.mPlayer.getCurrentPosition());
                                mSeekbarUpdateHandler.postDelayed(this, 50);
                            } else {
                                mSeekbarUpdateHandler.removeCallbacks(this);
                            }
                        } catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                    }
                };

                holder.ivPlay.setOnClickListener(view -> {
                    holder.mPlayer = new MediaPlayer();
                    // Set the media player audio stream type
                    holder.mPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
                    try {
                        holder.pbLoading.setVisibility(View.VISIBLE);
                        holder.ivPlay.setVisibility(View.GONE);
                        holder.ivStop.setVisibility(View.GONE);
                        holder.mPlayer.setDataSource(message.image_url);
                        holder.mPlayer.prepare();
                        holder.mPlayer.start();

                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    holder.mPlayer.setOnCompletionListener(mediaPlayer -> {
                        mSeekbarUpdateHandler.removeCallbacks(mUpdateSeekbar);
                        holder.mPlayer.stop();
                        holder.mPlayer.release();
                        holder.ivPlay.setVisibility(View.VISIBLE);
                        holder.seekBar.setProgress(0);
                        holder.ivStop.setVisibility(View.GONE);
                    });
                    holder.mPlayer.setOnPreparedListener(mediaPlayer -> {
                        holder.seekBar.setMax(mediaPlayer.getDuration());
                        mSeekbarUpdateHandler.postDelayed(mUpdateSeekbar, 500);
                        holder.pbLoading.setVisibility(View.GONE);
                        holder.ivPlay.setVisibility(View.GONE);
                        holder.ivStop.setVisibility(View.VISIBLE);
                    });

                });
                holder.seekBar.setOnTouchListener((view, motionEvent) -> true);
                holder.ivStop.setOnClickListener(view1 -> {
                    if (holder.mPlayer != null) {
                        holder.mPlayer.stop();
                        holder.mPlayer.release();
                    }
                    holder.ivPlay.setVisibility(View.VISIBLE);
                    holder.ivStop.setVisibility(View.GONE);
                });

                if (!Validators.isNullOrEmpty(message.created)) {
                    holder.tvMessageTime.setText(CommonFunctions.formatUnknownDateTime(message.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                } else {
                    holder.tvMessageTime.setText("");
                }
                String logo = "";
                if (message.admin == 1 && !Validators.isNullOrEmpty(loggedInUser.logo_name)) {
                    logo = loggedInUser.logo_name;
                } else if (message.admin == 0 && !Validators.isNullOrEmpty(customerImage)) {
                    logo = customerImage;
                }

            }
            if (getItemViewType(position) == R.layout.item_chat_date_group) {
                Dategroup dategroup = (Dategroup) objects.get(position);
                ChatDateGroupViewHolder holder = (ChatDateGroupViewHolder) viewHolder;
                holder.tvChatGroupDate.setText(dategroup.title);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return objects.size();
    }

    @Override
    public int getHeaderPositionForItem(int itemPosition) {
        int headerPosition = 0;
        do {
            if (this.isHeader(itemPosition)) {
                headerPosition = itemPosition;
                break;
            }
            itemPosition -= 1;
        } while (itemPosition >= 0);
        return headerPosition;
    }

    @Override
    public int getHeaderLayout(int headerPosition) {
        return R.layout.item_chat_date_group;
    }

    @Override
    public void bindHeaderData(View header, int headerPosition) {
        Dategroup dategroup = (Dategroup) objects.get(headerPosition);
        TextView tvChatGroupDate = header.findViewById(R.id.tvChatGroupDate);
        tvChatGroupDate.setText(dategroup.title);
    }

    @Override
    public boolean isHeader(int itemPosition) {
        return getItemViewType(itemPosition) == R.layout.item_chat_date_group;
    }


    protected static class MessageViewHolder extends RecyclerView.ViewHolder {
        private TextView tvMessage, tvMessageTime;
        private CardView cvMessage;
        private LinearLayout llMessage;

        public MessageViewHolder(@NonNull View itemView) {
            super(itemView);
            tvMessageTime = itemView.findViewById(R.id.tvMessageTime);
            tvMessage = itemView.findViewById(R.id.tvMessage);
            cvMessage = itemView.findViewById(R.id.cvMessage);
            llMessage = itemView.findViewById(R.id.llMessage);
        }
    }


    protected static class ChatImageMessageViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivMessage;
        private TextView tvMessageTime;


        public ChatImageMessageViewHolder(@NonNull View itemView) {
            super(itemView);
            ivMessage = itemView.findViewById(R.id.ivMessage);
            tvMessageTime = itemView.findViewById(R.id.tvMessageTime);
        }
    }

    protected static class ChatAudioViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivPlay, ivStop;
        private AppCompatSeekBar seekBar;
        MediaPlayer mPlayer;
        int totalDuration = 0;
        private ProgressBar pbLoading;
        private TextView tvMessageTime;

        public ChatAudioViewHolder(@NonNull View itemView) {
            super(itemView);
            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivStop = itemView.findViewById(R.id.ivStop);
            seekBar = itemView.findViewById(R.id.seekbar);
            pbLoading = itemView.findViewById(R.id.pbLoading);
            tvMessageTime = itemView.findViewById(R.id.tvMessageTime);
        }
    }

    protected static class ChatDateGroupViewHolder extends RecyclerView.ViewHolder {
        private TextView tvChatGroupDate;

        public ChatDateGroupViewHolder(@NonNull View itemView) {
            super(itemView);
            tvChatGroupDate = itemView.findViewById(R.id.tvChatGroupDate);
        }
    }
}
