package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.mikhaellopez.circularimageview.CircularImageView;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Chat;

import java.util.ArrayList;

/**
 * Created by Amrish on 13-11-2020.
 */
public class ChatListAdapter extends RecyclerView.Adapter<ChatListAdapter.ChatItemViewHolder> {
    private ArrayList<Chat> chats;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public ChatListAdapter(ArrayList<Chat> chats, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.chats = chats;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public ChatItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ChatItemViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_chat_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ChatItemViewHolder holder, int position) {
        try {
            Chat chatMessage = chats.get(position);
            holder.tvName.setText(chatMessage.user.first_name);
            holder.tvChatDate.setText(CommonFunctions.formatUnknownDateTime(chatMessage.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "EEE dd MMM"));
            if (chatMessage.unread_count_user > 0) {
                holder.rlChatCount.setVisibility(View.VISIBLE);
            } else {
                holder.rlChatCount.setVisibility(View.GONE);
            }
            holder.tvChatCount.setText(String.valueOf(chatMessage.unread_count_user));
            if (!Validators.isNullOrEmpty(chatMessage.user.image_url)) {
                Glide.with(holder.itemView.getContext())
                        .load(chatMessage.user.image_url)
                        .placeholder(R.drawable.avatar_logo_placeholder)
                        .error(R.drawable.avatar_logo_placeholder)
                        .into(holder.ivLogo);
            } else {
                holder.ivLogo.setImageResource(R.drawable.avatar_logo_placeholder);
            }
            holder.itemView.setOnClickListener(view -> {
                if (recyclerViewItemClickListener != null)
                    recyclerViewItemClickListener.onItemClick(position, chatMessage);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return chats.size();
    }

    protected static class ChatItemViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName, tvChatCount, tvChatDate;
        private CircularImageView ivLogo;
        private RelativeLayout rlChatCount;

        public ChatItemViewHolder(@NonNull View itemView) {
            super(itemView);
            tvChatCount = itemView.findViewById(R.id.tvUnreadCount);
            tvChatDate = itemView.findViewById(R.id.tvChatDate);
            tvName = itemView.findViewById(R.id.tvName);
            rlChatCount = itemView.findViewById(R.id.rlUnreadCount);
            ivLogo = itemView.findViewById(R.id.ivLogo);
        }
    }
}
