package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListener;
import com.tiffintom.partner1.models.Country;

import java.util.ArrayList;

/**
 * Created by Amrish on 16-10-2020.
 */
public class CountryAdapter extends RecyclerView.Adapter<CountryAdapter.CountryViewHolder> {
    private ArrayList<Country> countries;
    public String selectedCountry = null;
    private RecyclerItemViewClickListener recyclerViewItemClickListener;

    public CountryAdapter(ArrayList<Country> countries, String selectedCountry, RecyclerItemViewClickListener recyclerViewItemClickListener) {
        this.countries = countries;
        this.selectedCountry = selectedCountry;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public CountryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CountryViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_country, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CountryViewHolder holder, int position) {
        Country country = countries.get(position);
        holder.tvCountry.setText(country.name);

        holder.llCountry.setOnClickListener(view -> {
            selectedCountry = country.smallName;
            recyclerViewItemClickListener.onItemClick(view, position, country);
        });
    }

    @Override
    public int getItemCount() {
        return countries.size();
    }

    protected static class CountryViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llCountry;
        private TextView tvCountry;

        public CountryViewHolder(@NonNull View itemView) {
            super(itemView);
            llCountry = itemView.findViewById(R.id.llCountry);
            tvCountry = itemView.findViewById(R.id.tvCountry);
        }
    }
}
