package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.chauthai.swipereveallayout.SwipeRevealLayout;
import com.google.android.material.card.MaterialCardView;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.DeliveryFee;

import java.util.ArrayList;

/**
 * Created by Amrish on 14-12-2020.
 */
public class DeliveryFeesAdapter extends RecyclerView.Adapter<DeliveryFeesAdapter.DeliveryFeeViewHolder> {
    private ArrayList<DeliveryFee> deliveryFees;
    private RecyclerViewItemClickListener milesClickListener, feesClickListener;

    public DeliveryFeesAdapter(ArrayList<DeliveryFee> deliveryFees, RecyclerViewItemClickListener milesClickListener, RecyclerViewItemClickListener feesClickListener) {
        this.deliveryFees = deliveryFees;
        this.milesClickListener = milesClickListener;
        this.feesClickListener = feesClickListener;
    }

    @NonNull
    @Override
    public DeliveryFeeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new DeliveryFeeViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_delivery_fees, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull DeliveryFeeViewHolder holder, int position) {
        DeliveryFee deliveryFee = deliveryFees.get(position);
        if (!Validators.isNullOrEmpty(deliveryFee.delivery_charge)) {
            holder.tvDeliveryFee.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(deliveryFee.getDelivery_charge()));
        } else {
            holder.tvDeliveryFee.setText(MyApp.getInstance().getCurrencySymbol() + "0.00");
        }
        holder.tvMiles.setText((!Validators.isNullOrEmpty(deliveryFee.delivery_miles) ? deliveryFee.delivery_miles : "0") + " miles");
        holder.cvDeliveryMiles.setOnClickListener(view -> {
            if (milesClickListener != null) milesClickListener.onItemClick(position, deliveryFee);
        });
        holder.cvDeliveryFee.setOnClickListener(view -> {
            if (feesClickListener != null) feesClickListener.onItemClick(position, deliveryFee);
        });
        holder.llDelete.setOnClickListener(view -> {
            deliveryFees.remove(position);
            notifyDataSetChanged();
            holder.swipeRevealLayout.close(true);
        });
    }

    @Override
    public int getItemCount() {
        return deliveryFees.size();
    }

    protected static class DeliveryFeeViewHolder extends RecyclerView.ViewHolder {
        TextView tvDeliveryFeeNumber, tvDeliveryFee, tvEditDeliveryFee, tvMiles;
        MaterialCardView cvDeliveryFee, cvDeliveryMiles;
        LinearLayout llDelete;
        SwipeRevealLayout swipeRevealLayout;

        public DeliveryFeeViewHolder(@NonNull View itemView) {
            super(itemView);
            llDelete = itemView.findViewById(R.id.llDelete);
            swipeRevealLayout = itemView.findViewById(R.id.swipeRevealLayout);
            tvDeliveryFeeNumber = itemView.findViewById(R.id.tvDeliveryFeeNumber);
            tvDeliveryFee = itemView.findViewById(R.id.tvDeliveryFee);
            tvEditDeliveryFee = itemView.findViewById(R.id.tvEditDeliveryFee);
            tvMiles = itemView.findViewById(R.id.tvDeliveryMiles);

            cvDeliveryFee = itemView.findViewById(R.id.cvDeliveryFee);
            cvDeliveryMiles = itemView.findViewById(R.id.cvDeliveryMiles);
        }
    }
}
