package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.ReportTextModel;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

public class FullReportAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    public ArrayList<Object> objects;

    public FullReportAdapter(ArrayList<Object> objects) {
        this.objects = objects;
    }

    @Override
    public int getItemViewType(int position) {
        if (objects.get(position) instanceof ReportTextModel) {
            return R.layout.item_report_simple;
        } else {
            return R.layout.item_cart_product_empty;
        }

    }

    @Override
    public void onBindViewHolder(@NonNull @NotNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_report_simple) {
                ReportSimpleViewHolder viewHolder = (ReportSimpleViewHolder) holder;
                ReportTextModel keyValueModel = (ReportTextModel) objects.get(position);
                if(keyValueModel.isHeader){
                    viewHolder.llBody.setVisibility(View.GONE);
                    viewHolder.llHeader.setVisibility(View.VISIBLE);
                    viewHolder.tvHeaderText.setText(keyValueModel.title);
                }else {
                    viewHolder.llHeader.setVisibility(View.GONE);
                    viewHolder.llBody.setVisibility(View.VISIBLE);
                    viewHolder.tvTitle.setText(keyValueModel.title);
                    viewHolder.tvCount.setText(keyValueModel.orderCount);
                    if(keyValueModel.isPaymentSection){
                        viewHolder.tvValue.setText(keyValueModel.orderCount);
                    }else {
                        if(!Validators.isNullOrEmpty(keyValueModel.totalPrice)){
                            viewHolder.tvValue.setText(keyValueModel.totalPrice);
                        }else {
                            viewHolder.tvValue.setText(keyValueModel.orderCount);
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_report_simple) {
            return new ReportSimpleViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else {
            return new EmptyViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        }
    }


    @Override
    public int getItemCount() {
        return objects.size();
    }

    class ReportSimpleViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTitle, tvValue,tvHeaderText,tvCount;
        private LinearLayout llHeader;
        private ConstraintLayout llBody;

        public ReportSimpleViewHolder(@NonNull View itemView) {
            super(itemView);
            tvHeaderText = itemView.findViewById(R.id.tvHeaderText);
            llHeader = itemView.findViewById(R.id.llHeader);
            tvCount = itemView.findViewById(R.id.tvCount);
            llBody = itemView.findViewById(R.id.llBody);
            tvTitle = itemView.findViewById(R.id.tvTitle);
            tvValue = itemView.findViewById(R.id.tvValue);
        }
    }

    class EmptyViewHolder extends RecyclerView.ViewHolder {

        public EmptyViewHolder(@NonNull @NotNull View itemView) {
            super(itemView);
        }
    }
}
