package com.tiffintom.partner1.adapters;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.PartnerMedia;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/**
 * Created by Amrish on 29-01-2021.
 */
public class MediaAdapter extends RecyclerView.Adapter<MediaAdapter.MediaViewHolder> {
    private ArrayList<PartnerMedia> partnerMediaArrayList;

    public MediaAdapter(ArrayList<PartnerMedia> partnerMediaArrayList) {
        this.partnerMediaArrayList = partnerMediaArrayList;
    }

    @NonNull
    @Override
    public MediaViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new MediaViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_partner_media, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MediaViewHolder holder, int position) {
        PartnerMedia partnerMedia = partnerMediaArrayList.get(position);
        if (partnerMedia.type.equalsIgnoreCase("0")) {
            Glide.with(holder.itemView.getContext())
                    .load(partnerMedia.url)
                    .into(holder.ivMedia);
        } else if (partnerMedia.type.equalsIgnoreCase("1")) {
            Glide.with(holder.itemView.getContext())
                    .load("https://img.youtube.com/vi/" + extractYoutubeId(partnerMedia.url) + "/0.jpg")
                    .into(holder.ivMedia);
        } else {
            holder.ivMedia.setImageResource(R.drawable.banner_placeholder);
        }
        if (!Validators.isNullOrEmpty(partnerMedia.title)) {
            holder.tvTitle.setText(partnerMedia.title);
        } else {
            holder.tvTitle.setText("");
        }
        holder.ivMedia.setOnClickListener(view -> {
            if (partnerMedia.type.equalsIgnoreCase("1")) {
                Intent i = new Intent(Intent.ACTION_VIEW);
                i.setData(Uri.parse(partnerMedia.url));
                holder.itemView.getContext().startActivity(i);
            }
        });

    }

    @Override
    public int getItemCount() {
        return partnerMediaArrayList.size();
    }

    protected static class MediaViewHolder extends RecyclerView.ViewHolder {
        TextView tvTitle;
        ImageView ivMedia;

        public MediaViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
            ivMedia = itemView.findViewById(R.id.ivMedia);
        }
    }

    public String extractYoutubeId(String url) {
        String query = null;
        try {
            query = new URL(url).getQuery();
            String[] param = query.split("&");
            String id = null;
            for (String row : param) {
                String[] param1 = row.split("=");
                if (param1[0].equals("v")) {
                    id = param1[1];
                }
            }
            return id;
        } catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }

    }

    public static void watchYoutubeVideo(Context context, String id) {
        Intent appIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("vnd.youtube:" + id));
        Intent webIntent = new Intent(Intent.ACTION_VIEW,
                Uri.parse("http://www.youtube.com/watch?v=" + id));
        try {
            context.startActivity(appIntent);
        } catch (ActivityNotFoundException ex) {
            context.startActivity(webIntent);
        }
    }
}
