package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;

import java.util.ArrayList;

public class MenuListAdapter extends RecyclerView.Adapter<MenuListAdapter.ViewHolder> {
    private ArrayList<String> menus;
    private RecyclerViewItemClickListener itemClickListener;

    public MenuListAdapter(ArrayList<String> menus, RecyclerViewItemClickListener itemClickListener) {
        this.menus = menus;
        this.itemClickListener = itemClickListener;
    }


    @NonNull
    @Override
    public MenuListAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_menu_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MenuListAdapter.ViewHolder holder, int position) {
        String name = menus.get(position);
        holder.tvMenuName.setText(name);
        holder.llMenu.setOnClickListener(view -> {
            if (itemClickListener != null) {
                itemClickListener.onItemClick(position, name);
            }
        });
    }

    @Override
    public int getItemCount() {
        return menus.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llMenu;
        private TextView tvMenuName;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llMenu = itemView.findViewById(R.id.llMenu);
            tvMenuName = itemView.findViewById(R.id.tvMenuName);

        }
    }
}
