package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.MerchantBusinesses;

import java.util.ArrayList;

/**
 * Created by Amrish on 07-12-2020.
 */
public class MerchantBusinessSelectionAdapter extends RecyclerView.Adapter<MerchantBusinessSelectionAdapter.MerchantRestaurantViewHolder> {
    private ArrayList<MerchantBusinesses> merchantRestaurants;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public String selectedMerchantBusinessId = "";
    private RadioButton checkedRadioButton;

    public MerchantBusinessSelectionAdapter(ArrayList<MerchantBusinesses> merchantRestaurants, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.merchantRestaurants = merchantRestaurants;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public MerchantRestaurantViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new MerchantRestaurantViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_merchant_restaurants, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MerchantRestaurantViewHolder holder, int position) {
        MerchantBusinesses merchantRestaurant = merchantRestaurants.get(position);
        holder.rbMerchantRestaurant.setChecked(selectedMerchantBusinessId.equalsIgnoreCase(merchantRestaurant.id));

        holder.tvMerchantRestaurant.setText(merchantRestaurant.name);
        holder.itemView.setOnClickListener(view -> {
            selectedMerchantBusinessId = merchantRestaurant.id;
            notifyDataSetChanged();
            if (checkedRadioButton != null) checkedRadioButton.setChecked(false);
            checkedRadioButton = holder.rbMerchantRestaurant;
            holder.rbMerchantRestaurant.setChecked(true);
            if (recyclerViewItemClickListener != null)
                recyclerViewItemClickListener.onItemClick(position, merchantRestaurant);
        });
    }

    @Override
    public int getItemCount() {
        return merchantRestaurants.size();
    }

    protected static class MerchantRestaurantViewHolder extends RecyclerView.ViewHolder {

        private TextView tvMerchantRestaurant;
        private RadioButton rbMerchantRestaurant;

        public MerchantRestaurantViewHolder(@NonNull View itemView) {
            super(itemView);
            tvMerchantRestaurant = itemView.findViewById(R.id.tvMerchantRestaurant);
            rbMerchantRestaurant = itemView.findViewById(R.id.rbMerchantRestaurant);
        }
    }
}
