package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;

import java.util.ArrayList;

/**
 * Created by Amrish on 07-12-2020.
 */
public class MerchantPrinterAdapter extends RecyclerView.Adapter<MerchantPrinterAdapter.MerchantPrintersViewHolder> {
    private final ArrayList<String> printers;
    private final RecyclerViewItemClickListener recyclerViewItemClickListener;

    public String selectedMerchantPrinter = "";
    private RadioButton checkedRadioButton;

    public MerchantPrinterAdapter(ArrayList<String> printers, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.printers = printers;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public MerchantPrintersViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new MerchantPrintersViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_merchant_printer, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MerchantPrintersViewHolder holder, int position) {

        if (selectedMerchantPrinter != null)
            holder.rbMerchantStaticPrinter.setChecked(selectedMerchantPrinter.equalsIgnoreCase(printers.get(position)));
        else holder.rbMerchantStaticPrinter.setChecked(false);

        holder.tvMerchantStaticPrinter.setText(printers.get(position));
        holder.itemView.setOnClickListener(view -> {
            selectedMerchantPrinter = printers.get(position);
            notifyDataSetChanged();
            if (checkedRadioButton != null) checkedRadioButton.setChecked(false);
            checkedRadioButton = holder.rbMerchantStaticPrinter;
            holder.rbMerchantStaticPrinter.setChecked(true);
            if (recyclerViewItemClickListener != null)
                recyclerViewItemClickListener.onItemClick(position, printers.get(position));
        });
    }

    @Override
    public int getItemCount() {
        return printers.size();
    }

    protected static class MerchantPrintersViewHolder extends RecyclerView.ViewHolder {

        private TextView tvMerchantStaticPrinter;
        private RadioButton rbMerchantStaticPrinter;

        public MerchantPrintersViewHolder(@NonNull View itemView) {
            super(itemView);
            tvMerchantStaticPrinter = itemView.findViewById(R.id.tvMerchantStaticPrinter);
            rbMerchantStaticPrinter = itemView.findViewById(R.id.rbMerchantStaticPrinter);
        }
    }
}
