package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListener;
import com.tiffintom.partner1.models.MerchantCardTransaction;

import java.util.ArrayList;

public class MerchantRecentTransactionsAdapter extends RecyclerView.Adapter<MerchantRecentTransactionsAdapter.MerchantTransactionViewHolder> {
    private Activity activity;
    private ArrayList<MerchantCardTransaction> transactionModelArrayList;
    private RecyclerItemViewClickListener itemViewClickListener;

    public MerchantRecentTransactionsAdapter(Activity activity, ArrayList<MerchantCardTransaction> transactionModelArrayList, RecyclerItemViewClickListener itemViewClickListener) {
        this.activity = activity;
        this.transactionModelArrayList = transactionModelArrayList;
        this.itemViewClickListener = itemViewClickListener;
    }

    @NonNull
    @Override
    public MerchantTransactionViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new MerchantTransactionViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_merchant_recent_transaction, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MerchantTransactionViewHolder holder, int position) {
        MerchantCardTransaction merchantTransaction = transactionModelArrayList.get(position);
        holder.tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(merchantTransaction.amount / 100));
        if (!Validators.isNullOrEmpty(merchantTransaction.transaction_date_time))
            holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(merchantTransaction.transaction_date_time, MyApp.PHP_TIMEFORMAT, "hh:mm a"));
        else
            holder.tvDate.setText(CommonFunctions.formatMiliToDesireFormat(Long.parseLong(merchantTransaction.created + "000"), "hh:mm a"));
        holder.tvType.setText(merchantTransaction.type);
        if (merchantTransaction.type.equalsIgnoreCase("refund")) {
            holder.ivEntry.setImageResource(R.drawable.ic_baseline_remove_24);
            holder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.red));
            holder.tvBrand.setText(merchantTransaction.status);
            holder.tvBrand.setVisibility(View.GONE);
        } else {
            holder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.persian_green));
            holder.ivEntry.setImageResource(R.drawable.ic_baseline_add_24);
            holder.tvBrand.setText(merchantTransaction.card_brand);
            holder.tvBrand.setVisibility(View.VISIBLE);
        }
//        holder.btnRefund.setOnClickListener(view -> {
//            if (itemViewClickListener != null) {
//                itemViewClickListener.onItemClick(view, position, merchantTransaction);
//            }
//        });

        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        layoutParams.setMargins(CommonFunctions.pxToDp(activity, 8), CommonFunctions.pxToDp(activity, 4), CommonFunctions.pxToDp(activity, 8), CommonFunctions.pxToDp(activity, 4));
        holder.llMain.setLayoutParams(layoutParams);


    }

    @Override
    public int getItemCount() {
        return transactionModelArrayList.size() > 5 ? 4 : transactionModelArrayList.size();
    }

    public class MerchantTransactionViewHolder extends RecyclerView.ViewHolder {
        private TextView tvBrand, tvDate, tvAmount, tvType;
        private ImageView ivEntry;
        private LinearLayout llMain;
        private RadioButton rbChecked;

        public MerchantTransactionViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBrand = itemView.findViewById(R.id.tvBrand);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvType = itemView.findViewById(R.id.tvType);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            llMain = itemView.findViewById(R.id.llMainLayout);
            rbChecked = itemView.findViewById(R.id.rbChecked);

        }
    }
}
