package com.tiffintom.partner1.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.ExpandableItemClickListener;
import com.tiffintom.partner1.models.MerchantCardTransaction;
import com.tiffintom.partner1.models.MerchantExpandableModal;
import com.tiffintom.partner1.models.MerchantOrderTransaction;
import com.tiffintom.partner1.models.MerchantPaypalTransaction;

import java.util.ArrayList;

/**
 * Created by Amrish on 04-01-2021.
 */
public class MerchantTransactionsAdapter extends BaseExpandableListAdapter {
    Context context;
    // child data in format of header title, child title
    private ArrayList<MerchantExpandableModal> expandableModals;
    private ExpandableItemClickListener selectItemClickListener, refundClickListener, printClickListener, sendReceiptClickListener;
    public boolean showCheck = false;
    public boolean canRefund = false, isSendReceipt = false;
    public RadioButton lastCheckedRadio;
    public String defaultPrinter;

    private int merchantRole = MyApp.getInstance().getMyPreferences().getMerchantRole();


    public MerchantTransactionsAdapter(String defaultPrinter, Context context, ArrayList<MerchantExpandableModal> expandableModals, ExpandableItemClickListener selectItemClickListener, ExpandableItemClickListener refundClickListener, ExpandableItemClickListener printClickListener, ExpandableItemClickListener sendReceiptClickListener) {
        this.defaultPrinter = defaultPrinter;
        this.context = context;
        this.expandableModals = expandableModals;
        this.refundClickListener = refundClickListener;
        this.printClickListener = printClickListener;
        this.selectItemClickListener = selectItemClickListener;
        this.sendReceiptClickListener = sendReceiptClickListener;
        isSendReceipt = MyApp.getInstance().getMyPreferences().getMerchantBusinesses().send_receipt;
    }

    @Override
    public int getChildrenCount(int i) {
        return this.expandableModals.get(i).merchantTransactions.size();
//        return this._listDataChild.get(this._listDataHeader.get(i)).size();
    }

    @Override
    public Object getGroup(int groupPosition) {
        return expandableModals.get(groupPosition);
    }

    @Override
    public int getGroupCount() {
        return expandableModals.size();
    }

    @Override
    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @Override
    public Object getChild(int groupPosition, int childPosititon) {
        return expandableModals.get(groupPosition).merchantTransactions.get(childPosititon);
//        return this._listDataChild.get(this._listDataHeader.get(groupPosition))
//                .get(childPosititon);
    }

    @Override
    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public View getGroupView(int i, boolean b, View convertView, ViewGroup viewGroup) {
        if (convertView == null) {
            LayoutInflater infalInflater = (LayoutInflater) this.context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            //convertView = infalInflater.inflate(R.layout.item_merchant_transaction_header_expandable, null);
            convertView = infalInflater.inflate(R.layout.item_merchant_transaction_empty_view, null);
        }
       /* TextView tvMonth = convertView.findViewById(R.id.tvMonth);
        TextView tvTotal = convertView.findViewById(R.id.tvTotal);
        ImageView ivExpand = convertView.findViewById(R.id.ivExpand);
        RelativeLayout rvMain = convertView.findViewById(R.id.rvMain);
        rvMain.setVisibility(View.GONE);
        convertView.setVisibility(View.GONE);
        if (b) {
            ivExpand.setRotation(90f);
        } else {
            ivExpand.setRotation(0);
        }
        MerchantExpandableModal header = (MerchantExpandableModal) getGroup(i);
        tvMonth.setText(header.title);
        tvTotal.setText(MyApp.getInstance().currencySymbol + MyApp.df.format(Float.parseFloat(header.total)));*/
        return convertView;
    }

    @Override
    public View getChildView(int i, int i1, boolean b, View convertView, ViewGroup viewGroup) {
        if (convertView == null) {
            LayoutInflater infalInflater = (LayoutInflater) this.context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            convertView = infalInflater.inflate(R.layout.item_merchant_transaction_expandable, null);
        }
        TextView tvBrand, tvDate, tvAmount, tvType, tvOrderId, tvPaymentMethod;
        ImageView ivEntry;
        LinearLayout llMain;
        RadioButton rbChecked;
        MaterialButton btnRefund, btnPrint, btnSendReceipt, btnSendReceiptMobile;

        btnSendReceipt = convertView.findViewById(R.id.btnSendReceipt);
        btnSendReceiptMobile = convertView.findViewById(R.id.btnSendReceiptMobile);
        btnRefund = convertView.findViewById(R.id.btnRefund);
        btnPrint = convertView.findViewById(R.id.btnPrint);
        tvBrand = convertView.findViewById(R.id.tvBrand);
        tvDate = convertView.findViewById(R.id.tvDate);
        tvAmount = convertView.findViewById(R.id.tvAmount);
        tvType = convertView.findViewById(R.id.tvType);
        tvOrderId = convertView.findViewById(R.id.tvOrderId);
        tvPaymentMethod = convertView.findViewById(R.id.tvPaymentMethod);
        ivEntry = convertView.findViewById(R.id.ivEntry);
        llMain = convertView.findViewById(R.id.llMainLayout);
        rbChecked = convertView.findViewById(R.id.rbChecked);

        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        layoutParams.setMargins(CommonFunctions.pxToDp(context, 16), CommonFunctions.pxToDp(context, 8), CommonFunctions.pxToDp(context, 16), CommonFunctions.pxToDp(context, 8));
        llMain.setLayoutParams(layoutParams);

        Object object = getChild(i, i1);
        tvOrderId.setVisibility(View.GONE);
        tvPaymentMethod.setVisibility(View.GONE);
        if (object instanceof MerchantCardTransaction) {
            if (isSendReceipt) {
                if (defaultPrinter.equalsIgnoreCase("mobile")) {
                    btnSendReceiptMobile.setVisibility(View.VISIBLE);
                    btnSendReceipt.setVisibility(View.GONE);
                }else {
                    btnSendReceiptMobile.setVisibility(View.GONE);
                    btnSendReceipt.setVisibility(View.VISIBLE);
                }
            } else {
                btnSendReceipt.setVisibility(View.GONE);
                btnSendReceiptMobile.setVisibility(View.GONE);
            }
            MerchantCardTransaction merchantTransaction = (MerchantCardTransaction) getChild(i, i1);
            tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(merchantTransaction.amount / 100));
            if (!Validators.isNullOrEmpty(merchantTransaction.transaction_date_time))
                tvDate.setText(CommonFunctions.formatUnknownDateTime(merchantTransaction.transaction_date_time, MyApp.PHP_TIMEFORMAT, "dd MMM, hh:mm a"));
            else {
                tvDate.setText(CommonFunctions.formatMiliToDesireFormat(Long.parseLong(merchantTransaction.created + "000"), "dd MMM, hh:mm a"));
            }
            tvType.setText(merchantTransaction.reporting_category);

            if (merchantTransaction.reporting_category.equalsIgnoreCase("charge")) {
                if (canRefund && !merchantTransaction.refunded) {
                    btnRefund.setVisibility(View.VISIBLE);
                } else {
                    btnRefund.setVisibility(View.GONE);
                }
                tvBrand.setText(merchantTransaction.card_brand);
                if (defaultPrinter.equalsIgnoreCase("mobile")) {
                    btnPrint.setVisibility(View.GONE);
                } else {
                    btnPrint.setVisibility(View.VISIBLE);
                }
            } else if (merchantTransaction.reporting_category.equalsIgnoreCase("refund")) {
                tvBrand.setVisibility(View.GONE);
                btnRefund.setVisibility(View.GONE);
                btnPrint.setVisibility(View.GONE);
            } else {
                tvBrand.setVisibility(View.GONE);
                btnRefund.setVisibility(View.GONE);
                btnPrint.setVisibility(View.GONE);
            }
            if (showCheck) {
                rbChecked.setVisibility(View.VISIBLE);
                rbChecked.setChecked(merchantTransaction.checked);
                rbChecked.setEnabled(true);
                llMain.setOnClickListener(v -> {
                    if (showCheck) {
                        merchantTransaction.checked = !merchantTransaction.checked;
                        rbChecked.setChecked(merchantTransaction.checked);
                        if (selectItemClickListener != null) {
                            selectItemClickListener.onItemClick(i, i1, merchantTransaction);
                        }
                    }
                });
            } else {
                rbChecked.setVisibility(View.GONE);
                rbChecked.setEnabled(false);
            }
        }
        if (object instanceof MerchantPaypalTransaction) {
            MerchantPaypalTransaction paypalTransaction = (MerchantPaypalTransaction) getChild(i, i1);
            tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(paypalTransaction.transaction_amount));
            tvDate.setText(CommonFunctions.formatUnknownDateTime(paypalTransaction.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd MMM, hh:mm a"));
            tvType.setText(paypalTransaction.sale_state);
            tvBrand.setVisibility(View.GONE);
            if (paypalTransaction.sale_state.equalsIgnoreCase("refunded")) {
                btnRefund.setVisibility(View.GONE);
                btnPrint.setVisibility(View.GONE);
            } else if (paypalTransaction.sale_state.equalsIgnoreCase("partially_refunded")) {
                if (canRefund) btnRefund.setVisibility(View.VISIBLE);
                else btnRefund.setVisibility(View.GONE);
                btnPrint.setVisibility(View.GONE);
                tvBrand.setVisibility(View.GONE);
                tvBrand.setText(MyApp.getInstance().currencySymbol + MyApp.df.format(paypalTransaction.refunded_amount) + " refunded");
            } else if (paypalTransaction.sale_state.equalsIgnoreCase("completed")) {
                if (canRefund) {
                    btnRefund.setVisibility(View.VISIBLE);
                } else {
                    btnRefund.setVisibility(View.GONE);
                }
                btnPrint.setVisibility(View.GONE);
            } else {
                btnRefund.setVisibility(View.GONE);
                btnPrint.setVisibility(View.GONE);
            }
            if (showCheck) {
                rbChecked.setVisibility(View.VISIBLE);
                rbChecked.setChecked(paypalTransaction.checked);
                rbChecked.setEnabled(true);
                llMain.setOnClickListener(v -> {
                    if (showCheck) {
                        paypalTransaction.checked = !paypalTransaction.checked;
                        rbChecked.setChecked(paypalTransaction.checked);
                        if (selectItemClickListener != null) {
                            selectItemClickListener.onItemClick(i, i1, paypalTransaction);
                        }
                    }
                });
            } else {
                rbChecked.setVisibility(View.GONE);
                rbChecked.setEnabled(false);
            }
        }
        if (object instanceof MerchantOrderTransaction) {
            btnSendReceipt.setVisibility(View.GONE);
            btnSendReceiptMobile.setVisibility(View.GONE);
            MerchantOrderTransaction orderTransaction = (MerchantOrderTransaction) getChild(i, i1);
            if (orderTransaction.calculated_fees != null) {
                tvAmount.setText("-" + MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(orderTransaction.calculated_fees.total_fee));
            } else {
                tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(orderTransaction.grand_total));
            }
            tvDate.setText(CommonFunctions.formatUnknownDateTime(orderTransaction.order_date, "yyyy-MM-dd HH:mm:ss", "dd MMM, hh:mm a"));

            tvType.setText(orderTransaction.order_status);
            tvBrand.setText(orderTransaction.order_type);
            btnRefund.setVisibility(View.GONE);
            btnPrint.setVisibility(View.GONE);
            tvBrand.setVisibility(View.VISIBLE);
            tvOrderId.setVisibility(View.VISIBLE);
            tvPaymentMethod.setVisibility(View.VISIBLE);
            tvOrderId.setText("#ODR" + orderTransaction.order_id);
            tvPaymentMethod.setText("COD");

            if (showCheck) {
                rbChecked.setVisibility(View.VISIBLE);
                rbChecked.setChecked(orderTransaction.checked);
                rbChecked.setEnabled(true);
                llMain.setOnClickListener(v -> {
                    if (showCheck) {
                        orderTransaction.checked = !orderTransaction.checked;
                        rbChecked.setChecked(orderTransaction.checked);
                        if (selectItemClickListener != null) {
                            selectItemClickListener.onItemClick(i, i1, orderTransaction);
                        }
                    }
                });
            } else {
                rbChecked.setVisibility(View.GONE);
                rbChecked.setEnabled(false);
            }
        }
        btnRefund.setOnClickListener(view -> {
            if (refundClickListener != null) {
                refundClickListener.onItemClick(i, i1, object);
            }
        });
        btnPrint.setOnClickListener(view -> {
            if (printClickListener != null) {
                printClickListener.onItemClick(i, i1, object);
            }
        });
        btnSendReceipt.setOnClickListener(view -> {
            if (sendReceiptClickListener != null) {
                sendReceiptClickListener.onItemClick(i, i1, object);
            }
        });
        btnSendReceiptMobile.setOnClickListener(view -> {
            if (sendReceiptClickListener != null) {
                sendReceiptClickListener.onItemClick(i, i1, object);
            }
        });

        return convertView;
    }

    @Override
    public boolean isChildSelectable(int i, int i1) {
        return true;
    }
}
