package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.OrderProductDetail;
import com.tiffintom.partner1.utils.LogUtils;

import java.text.DecimalFormat;
import java.util.ArrayList;

/**
 * Created by Amrish on 07-09-2020.
 */
public class OrderedProductItemsAdapter extends RecyclerView.Adapter<OrderedProductItemsAdapter.ItemViewHolder> {

    private ArrayList<OrderProductDetail> orderedItems;
    private boolean showPrice = false;

    public OrderedProductItemsAdapter(ArrayList<OrderProductDetail> orderedItems) {
        this.orderedItems = orderedItems;
    }

    public OrderedProductItemsAdapter(ArrayList<OrderProductDetail> orderedItems, boolean showPrice) {
        this.orderedItems = orderedItems;
        this.showPrice = showPrice;
    }

    private DecimalFormat df = new DecimalFormat("#.##");

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ItemViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_ordered_product_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder holder, int position) {

        OrderProductDetail cart = orderedItems.get(position);
        holder.tvName.setText(cart.menu_name);
        holder.tvCount.setText(String.valueOf(cart.quantity));
        holder.tvSubAddon.setText(cart.subaddons_name);
        if (!Validators.isNullOrEmpty(cart.subaddons_name)) {
            holder.tvSubAddon.setVisibility(View.VISIBLE);
        } else {
            holder.tvSubAddon.setVisibility(View.GONE);
        }
        LogUtils.e("SubAddon::", cart.subaddons_name);
        LogUtils.e("SubAddon::", holder.tvSubAddon.getText().toString());
        if (showPrice) {
            holder.tvPrice.setVisibility(View.VISIBLE);
        } else {
            holder.tvPrice.setVisibility(View.GONE);
        }
        holder.tvPrice.setText(String.format("%s%s", MyApp.getInstance().getCurrencySymbol(), MyApp.df.format(cart.total_price)));
    }

    @Override
    public int getItemCount() {
        return orderedItems.size();
    }

    @Override
    public long getItemId(int position) {
        return orderedItems.get(position).id;
    }

    protected static class ItemViewHolder extends RecyclerView.ViewHolder {

        private TextView tvCount, tvName, tvPrice, tvSubAddon;

        public ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            tvCount = itemView.findViewById(R.id.tvCount);
            tvName = itemView.findViewById(R.id.tvName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvSubAddon = itemView.findViewById(R.id.tvSubAddon);
        }
    }
}
