package com.tiffintom.partner1.adapters

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.cardview.widget.CardView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.tiffintom.partner1.R
import com.tiffintom.partner1.models.AppIntroModel


class PaymentTypeSelectionAdapter internal constructor(
    context: Context?,
    paymentTypeSelection: List<AppIntroModel>,
    var onItemClicked: (AppIntroModel, Int) -> Unit
) :
    RecyclerView.Adapter<PaymentTypeSelectionAdapter.ViewHolder>() {
    val paymentTypeSelection: List<AppIntroModel>
    private val mInflater: LayoutInflater

    // data is passed into the constructor
    init {
        mInflater = LayoutInflater.from(context)
        this.paymentTypeSelection = paymentTypeSelection
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view: View = mInflater.inflate(R.layout.raw_payment_type_selection, parent, false)
        return ViewHolder(view)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.txtType.text = paymentTypeSelection[position].title
        holder.itemView.rootView.setOnClickListener {
            onItemClicked.invoke(paymentTypeSelection[position], position)
        }
    }

    // total number of rows
    override fun getItemCount(): Int {
        return paymentTypeSelection.size
    }

    // stores and recycles views as they are scrolled off screen
    inner class ViewHolder internal constructor(itemView: View) : RecyclerView.ViewHolder(itemView),
        View.OnClickListener {
        var txtType: TextView


        init {
            txtType = itemView.findViewById(R.id.txtType)
            itemView.setOnClickListener(this)
        }

        override fun onClick(view: View) {

        }
    }

}