package com.tiffintom.partner1.adapters;

import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Variants;

import java.util.ArrayList;

public class PriceVarientListAdapter extends RecyclerView.Adapter<PriceVarientListAdapter.ViewHolder> {
    private ArrayList<Variants> variants;
    private RecyclerViewItemClickListener editClickListener, requiredClickListener;

    public PriceVarientListAdapter(ArrayList<Variants> variant, RecyclerViewItemClickListener editClickListener, RecyclerViewItemClickListener requiredClickListener) {
        this.variants = variant;
        this.editClickListener = editClickListener;
        this.requiredClickListener = requiredClickListener;
    }


    @NonNull
    @Override
    public PriceVarientListAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_multiple_products, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Variants variants = this.variants.get(position);
        holder.tvVariants.setText(variants.sub_name);
        holder.tvPrice.setText(variants.orginal_price);

        holder.checkBox.setOnCheckedChangeListener((compoundButton, b) -> {
            // variants.status = holder.checkBox.isChecked();
            if (holder.checkBox.isChecked()) {
                variants.required = true;
            } else {
                variants.required = false;
            }
            if (requiredClickListener != null) {
                requiredClickListener.onItemClick(position, variants);
            }

        });
        holder.tvEdit.setOnClickListener(view -> {
            if (editClickListener != null) {
                editClickListener.onItemClick(position, variants);
            }
        });
    }

    @Override
    public int getItemCount() {
        return variants.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llVarients;
        private TextView tvVariants, tvPrice, tvEdit;
        private AppCompatCheckBox checkBox;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llVarients = itemView.findViewById(R.id.ll_PriceVariants);
            tvVariants = itemView.findViewById(R.id.tvVariants);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvEdit = itemView.findViewById(R.id.tvEdit);
            checkBox = itemView.findViewById(R.id.cbRequired);
            checkBox.setChecked(true);
            tvEdit.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
        }
    }
}
