package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.models.TransactionSummaryDynamic;

import java.util.ArrayList;

/**
 * Created by Amrish on 07-12-2020.
 */
public class PrintTransactionsReportAdapter extends RecyclerView.Adapter<PrintTransactionsReportAdapter.FiltersViewHolder> {
    private ArrayList<TransactionSummaryDynamic> summaryDynamics;

    public String selectedFilter = "";

    public PrintTransactionsReportAdapter(ArrayList<TransactionSummaryDynamic> summaryDynamics) {
        this.summaryDynamics = summaryDynamics;
    }

    public void notifyList(ArrayList<TransactionSummaryDynamic> summaryDynamic){
        this.summaryDynamics = summaryDynamic;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public FiltersViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new FiltersViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_transaction_report, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull FiltersViewHolder holder, int position) {
        TransactionSummaryDynamic filter = summaryDynamics.get(position);
        holder.tvTitle.setText(filter.title);
        holder.tvValue.setText(filter.value);
    }

    @Override
    public int getItemCount() {
        return summaryDynamics.size();
    }

    protected static class FiltersViewHolder extends RecyclerView.ViewHolder {

        private TextView tvTitle,tvValue;
        public FiltersViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
            tvValue = itemView.findViewById(R.id.tvValue);
        }
    }
}
