package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;

import java.util.ArrayList;

/**
 * Created by Amrish on 11-11-2020.
 */
public class ReasonSelectionAdapter extends RecyclerView.Adapter<ReasonSelectionAdapter.ReasonViewHolder> {
    private String selectedReason = "";
    private ArrayList<String> reasons;
    private RecyclerViewItemClickListener recyclerItemViewClickListener;

    public ReasonSelectionAdapter(ArrayList<String> reasons, RecyclerViewItemClickListener recyclerItemViewClickListener) {
        this.reasons = reasons;
        this.recyclerItemViewClickListener = recyclerItemViewClickListener;
    }

    @NonNull
    @Override
    public ReasonViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ReasonViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_reason, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ReasonViewHolder holder, int position) {
        if (selectedReason.equalsIgnoreCase(reasons.get(position))) {
            holder.cvReason.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.reason_selected));
            holder.tvReason.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.white));
        } else {
            holder.cvReason.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.reason_normal));
            holder.tvReason.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.reason_normal_text));
        }
        holder.cvReason.setOnClickListener(view -> {
            selectedReason = reasons.get(position);
            if (recyclerItemViewClickListener != null)
                recyclerItemViewClickListener.onItemClick(position, reasons.get(position));
        });
        holder.tvReason.setText(reasons.get(position));
    }

    @Override
    public int getItemCount() {
        return reasons.size();
    }

    protected static class ReasonViewHolder extends RecyclerView.ViewHolder {
        private TextView tvReason;
        private MaterialCardView cvReason;

        public ReasonViewHolder(@NonNull View itemView) {
            super(itemView);
            tvReason = itemView.findViewById(R.id.tvReason);
            cvReason = itemView.findViewById(R.id.cvReason);
        }
    }
}
