package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.OrderDetail;

import java.util.ArrayList;

/**
 * Created by Amrish on 18-09-2020.
 */
public class RecentOrdersAdapter extends RecyclerView.Adapter<RecentOrdersAdapter.RestaurantViewHolder> {


    private ArrayList<OrderDetail> recentOrders;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public RecentOrdersAdapter(ArrayList<OrderDetail> recentOrders, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.recentOrders = recentOrders;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public RestaurantViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new RestaurantViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_recent_orders_customer, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RestaurantViewHolder holder, int position) {
        OrderDetail order = recentOrders.get(position);
        holder.tvRestaurant.setText(order.customer_name);
        holder.tvOrderId.setText("Order #" + order.id);

        if (!Validators.isNullOrEmpty(order.payment_method)) {

            if (order.payment_method.equalsIgnoreCase("stripe"))
                holder.tvPaymentMode.setText("Credit/Debit Card");

            else if (order.payment_method.equalsIgnoreCase("paypal"))
                holder.tvPaymentMode.setText("PayPal");

            else if (order.payment_method.equalsIgnoreCase("credit") || order.payment_method.equalsIgnoreCase("wallet"))
                holder.tvPaymentMode.setText("TiffinTom credit");

            else
                holder.tvPaymentMode.setText("Cash on delivery");
        }

        holder.tvOrderTotal.setText("Total: " + MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(order.order_grand_total));

        holder.itemView.setOnClickListener(view -> {
            if (recyclerViewItemClickListener != null)
                recyclerViewItemClickListener.onItemClick(position, order);
        });
    }

    @Override
    public int getItemCount() {
        return recentOrders.size();
    }

    protected static class RestaurantViewHolder extends RecyclerView.ViewHolder {
        private TextView tvRestaurant, tvOrderId, tvOrderDate, tvOrderTotal, tvPaymentMode;

        public RestaurantViewHolder(@NonNull View itemView) {
            super(itemView);
            tvOrderId = itemView.findViewById(R.id.tvOrderNumber);
            tvOrderTotal = itemView.findViewById(R.id.tvOrderTotal);
            tvOrderDate = itemView.findViewById(R.id.tvOrderDate);
            tvRestaurant = itemView.findViewById(R.id.tvRestaurant);
            tvPaymentMode = itemView.findViewById(R.id.tvPaymentType);
        }
    }
}
