package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.iarcuschin.simpleratingbar.SimpleRatingBar;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.LatestReviewModel;

import java.util.ArrayList;

public class RecentReviewViewPagerAdapter extends PagerAdapter {

    private LayoutInflater layoutInflater;
    private Activity activity;
    private ArrayList<Object> reviewArrayList;

    public RecentReviewViewPagerAdapter(Activity activity, ArrayList<Object> reviewArrayList) {
        this.activity = activity;
        this.reviewArrayList = reviewArrayList;
    }

    @Override
    public int getCount() {
        return reviewArrayList.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        layoutInflater = (LayoutInflater) activity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = layoutInflater.inflate(R.layout.recent_review_items, null);
        LatestReviewModel latestReviewModel = (LatestReviewModel) reviewArrayList.get(position);

        TextView tvRatings = view.findViewById(R.id.tvRating);
        TextView tvMessage = view.findViewById(R.id.tvMessage);
        SimpleRatingBar ratingBar = view.findViewById(R.id.rating);
        TextView tvDate = view.findViewById(R.id.tvDate);
        TextView tvName = view.findViewById(R.id.tvName);
        if (!Validators.isNullOrEmpty(latestReviewModel.rating)) {
            tvRatings.setText(latestReviewModel.rating + "/5");
            ratingBar.setRating(Float.parseFloat(latestReviewModel.rating));
        } else {
            tvRatings.setText("0/0");
        }
        tvMessage.setText(latestReviewModel.message);
        tvName.setText(latestReviewModel.first_name);
        tvDate.setText(CommonFunctions.formatUnknownDateTime(latestReviewModel.created, "yyyy-MM-dd", "dd/MM/yyyy"));
        container.addView(view);
        return view;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        ViewPager vp = (ViewPager) container;
        View view = (View) object;
        vp.removeView(view);
    }
}
