package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListener;
import com.tiffintom.partner1.models.TransactionModel;

import java.util.ArrayList;

public class RecentTransactionsAdapter extends RecyclerView.Adapter<RecentTransactionsAdapter.ViewHolder> {
    private Activity activity;
    private ArrayList<TransactionModel> transactionModelArrayList;
    private RecyclerItemViewClickListener itemViewClickListener;

    public RecentTransactionsAdapter(Activity activity, ArrayList<TransactionModel> transactionModelArrayList, RecyclerItemViewClickListener itemViewClickListener) {
        this.activity = activity;
        this.transactionModelArrayList = transactionModelArrayList;
        this.itemViewClickListener = itemViewClickListener;
    }

    @NonNull
    @Override
    public RecentTransactionsAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_recent_transactions, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecentTransactionsAdapter.ViewHolder holder, int position) {
        TransactionModel transactionModel = transactionModelArrayList.get(position);
        holder.tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + transactionModel.total);
        holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(transactionModel.payment_date, MyApp.PHP_TIMEFORMAT, "EEE dd/MM"));
        if (transactionModel.status.equalsIgnoreCase("refunded")) {
            holder.ivEntry.setImageResource(R.drawable.ic_baseline_remove_24);
            holder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.red));
            holder.tvBrand.setText(transactionModel.status);
        } else {
            holder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.persian_green));
            holder.ivEntry.setImageResource(R.drawable.ic_baseline_add_24);
            if (transactionModel.payment_type.equalsIgnoreCase("stripe")) {
                holder.tvBrand.setText(transactionModel.brand);
            } else {
                holder.tvBrand.setText(transactionModel.payment_type);
            }
        }


    }

    @Override
    public int getItemCount() {
        return transactionModelArrayList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvBrand, tvDate, tvAmount;
        private ImageView ivEntry;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBrand = itemView.findViewById(R.id.tvBrand);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            ivEntry = itemView.findViewById(R.id.ivEntry);

        }
    }
}
