package com.tiffintom.partner1.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.TransactionSummaryDynamic;

import java.util.ArrayList;

/**
 * Created by Amrish on 07-12-2020.
 */
public class ReportSummaryFiltersAdapter extends RecyclerView.Adapter<ReportSummaryFiltersAdapter.FiltersViewHolder> {
    private ArrayList<TransactionSummaryDynamic> summaryDynamics;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public String selectedFilter = "";

    public ReportSummaryFiltersAdapter(ArrayList<TransactionSummaryDynamic> summaryDynamics, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.summaryDynamics = summaryDynamics;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public FiltersViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new FiltersViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_filter, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull FiltersViewHolder holder, int position) {
        TransactionSummaryDynamic filter = summaryDynamics.get(position);

        if (selectedFilter != null && filter.filter.equalsIgnoreCase(selectedFilter)) {
            holder.llFilter.setBackground(ContextCompat.getDrawable(holder.itemView.getContext(), R.drawable.primary_checkbox_checked));
            holder.tvTitle.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.white));
        } else {
            holder.llFilter.setBackground(ContextCompat.getDrawable(holder.itemView.getContext(), R.drawable.primary_checkbox_unchecked));
            holder.tvTitle.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.black));
        }
        holder.tvTitle.setText(filter.title);
        holder.itemView.setOnClickListener(view -> {
            selectedFilter = filter.filter;
            notifyDataSetChanged();
            if (recyclerViewItemClickListener != null)
                recyclerViewItemClickListener.onItemClick(position, filter);
        });
    }

    @Override
    public int getItemCount() {
        return summaryDynamics.size();
    }

    protected static class FiltersViewHolder extends RecyclerView.ViewHolder {

        private TextView tvTitle;
        private LinearLayout llFilter;

        public FiltersViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
            llFilter = itemView.findViewById(R.id.llFilter);

        }
    }
}
