package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListener;
import com.tiffintom.partner1.models.OrderStatusIndicatorHeader;
import com.tiffintom.partner1.models.Reservation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by Amrish on 09-11-2020.
 */
public class ReservationsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements StickHeaderItemDecoration.StickyHeaderInterface {
    private ArrayList<Object> ordersList;
    private Activity activity;
    private RecyclerItemViewClickListener itemViewClickListener, itemAcceptClickListener, itemCancelClickListener, printClickListener;
    Calendar todayCalendar = Calendar.getInstance();
    Date todayDate = new Date();

    public ReservationsAdapter(FragmentActivity activity, ArrayList<Object> ordersList, RecyclerItemViewClickListener itemViewClickListener, RecyclerItemViewClickListener itemAcceptClickListener, RecyclerItemViewClickListener itemCancelClickListener, RecyclerItemViewClickListener printClickListener) {
        todayCalendar.add(Calendar.DAY_OF_MONTH, -1);
        this.ordersList = ordersList;
        this.activity = activity;
        this.itemViewClickListener = itemViewClickListener;
        this.itemAcceptClickListener = itemAcceptClickListener;
        this.itemCancelClickListener = itemCancelClickListener;
        this.printClickListener = printClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (ordersList.get(position) instanceof Reservation) {
            return R.layout.item_order_list;
        } else {
            return R.layout.item_orders_status_indicator;
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        if (viewType == R.layout.item_order_list) {
            return new OrderViewHolder(view);
        } else {
            return new OrderStatusHeaderViewHolder(view);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (getItemViewType(position) == R.layout.item_orders_status_indicator) {
            OrderStatusHeaderViewHolder viewHolder = (OrderStatusHeaderViewHolder) holder;
            OrderStatusIndicatorHeader header = (OrderStatusIndicatorHeader) ordersList.get(position);
            viewHolder.tvTitle.setText(header.title);
        }
        if (getItemViewType(position) == R.layout.item_order_list) {
            OrderViewHolder viewHolder = (OrderViewHolder) holder;
            Reservation reservation = (Reservation) ordersList.get(position);


            String chipMessage = "View";

            if (reservation.status.equalsIgnoreCase("pending")) {
                chipMessage = "Accept";
            } else if (reservation.status.equalsIgnoreCase("cancelled") || reservation.status.equalsIgnoreCase("cancel")) {
                chipMessage = "Cancelled";
            } else if (reservation.status.equalsIgnoreCase("approved")) {
                chipMessage = "Completed";
            }

            if (reservation.status.equalsIgnoreCase("pending")) {
                viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_green));
                viewHolder.tvOrderStatus.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.tvView.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.tvCustomerName.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.tvAddress.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.tvTime.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.tvReservationId.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.ivPrint.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.white)));
            } else {
                viewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_grey));
                viewHolder.tvOrderStatus.setTextColor(activity.getResources().getColor(R.color.light_black));
                viewHolder.tvView.setTextColor(activity.getResources().getColor(R.color.light_black));
                viewHolder.tvCustomerName.setTextColor(activity.getResources().getColor(R.color.light_black));
                viewHolder.tvAddress.setTextColor(activity.getResources().getColor(R.color.light_black));
                viewHolder.tvTime.setTextColor(activity.getResources().getColor(R.color.light_black));
                viewHolder.tvReservationId.setTextColor(activity.getResources().getColor(R.color.light_black));
                viewHolder.ivPrint.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.black)));
            }
            viewHolder.ivPrint.setVisibility(View.VISIBLE);
            viewHolder.tvView.setVisibility(View.VISIBLE);
            viewHolder.tvView.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);

            if (chipMessage.equalsIgnoreCase("completed")) {
                viewHolder.chip.setEnabled(false);
                viewHolder.chip.setCloseIconVisible(true);
                viewHolder.chip.setCloseIcon(ContextCompat.getDrawable(activity, R.drawable.ic_baseline_green_done_24));
                viewHolder.chip.setCloseIconTint(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.chip_green_color)));
                viewHolder.chip.setTextColor(activity.getResources().getColor(R.color.chip_green_color));
                viewHolder.chip.setChipBackgroundColor(ContextCompat.getColorStateList(activity, R.color.orders_card_bg_grey));
            } else if (chipMessage.equalsIgnoreCase("cancelled")) {
                viewHolder.chip.setEnabled(false);
                viewHolder.chip.setCloseIconVisible(true);
                viewHolder.chip.setCloseIcon(ContextCompat.getDrawable(activity, R.drawable.ic_baseline_close_24));
                viewHolder.chip.setCloseIconTint(ColorStateList.valueOf(ContextCompat.getColor(activity, R.color.chip_orange_color)));
                viewHolder.chip.setTextColor(activity.getResources().getColor(R.color.chip_orange_color));
                viewHolder.chip.setChipBackgroundColor(ContextCompat.getColorStateList(activity, R.color.orders_card_bg_grey));
            } else {
                viewHolder.chip.setEnabled(true);
                viewHolder.chip.setCloseIconVisible(false);
                viewHolder.chip.setTextColor(activity.getResources().getColor(R.color.white));
                viewHolder.chip.setChipBackgroundColor(ContextCompat.getColorStateList(activity, R.color.chip_green_color));
            }


            viewHolder.tvOrderStatus.setText(reservation.guest_count + " guests");
            viewHolder.tvCustomerName.setText(reservation.customer_name);
            viewHolder.tvAddress.setText(reservation.booking_phone);
            viewHolder.tvTime.setText(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd MMM yyyy") + " at " + reservation.booking_time);
            viewHolder.chip.setText(chipMessage);

            viewHolder.tvView.setOnClickListener(v -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(v, position, reservation);
                }
            });
            viewHolder.cvOrder.setOnClickListener(v -> {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(v, position, reservation);
                }
            });
            viewHolder.ivPrint.setOnClickListener(view -> {
                if (printClickListener != null) {
                    printClickListener.onItemClick(view, position, reservation);
                }
            });


            String finalChipMessage = chipMessage;
            viewHolder.chip.setOnClickListener(v -> {
                if (finalChipMessage.equalsIgnoreCase("accept")) {
                    if (itemAcceptClickListener != null) {
                        itemAcceptClickListener.onItemClick(v, position, reservation);
                    }
                }
                if (finalChipMessage.equalsIgnoreCase("cancel")) {
                    if (itemCancelClickListener != null) {
                        itemCancelClickListener.onItemClick(v, position, reservation);
                    }
                }
            });
            viewHolder.tvCustomerName.setText(reservation.booking_id);
            viewHolder.tvReservationId.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return ordersList.size();
    }

    @Override
    public int getHeaderPositionForItem(int itemPosition) {
        int headerPosition = 0;
        do {
            if (this.isHeader(itemPosition)) {
                headerPosition = itemPosition;
                break;
            }
            itemPosition -= 1;
        } while (itemPosition >= 0);
        return headerPosition;
    }

    @Override
    public int getHeaderLayout(int headerPosition) {
        return R.layout.item_orders_status_indicator;
    }

    @Override
    public void bindHeaderData(View header, int headerPosition) {
        TextView tvTitle = header.findViewById(R.id.tvTitle);
        OrderStatusIndicatorHeader indicatorHeader = (OrderStatusIndicatorHeader) ordersList.get(headerPosition);
        tvTitle.setText(indicatorHeader.title);
    }

    @Override
    public boolean isHeader(int itemPosition) {
        return getItemViewType(itemPosition) == R.layout.item_orders_status_indicator;
    }

    protected static class OrderViewHolder extends RecyclerView.ViewHolder {
        private MaterialCardView cvOrder;
        private TextView tvOrderStatus, tvCustomerName, tvAddress, tvTime, tvView, tvReservationId;
        private AppCompatImageView ivPrint;
        private Chip chip;

        public OrderViewHolder(@NonNull View itemView) {
            super(itemView);
            cvOrder = itemView.findViewById(R.id.cvOrder);
            tvOrderStatus = itemView.findViewById(R.id.tvOrderStatus);
            tvCustomerName = itemView.findViewById(R.id.tvName);
            tvAddress = itemView.findViewById(R.id.tvAddress);
            tvTime = itemView.findViewById(R.id.tvTime);
            ivPrint = itemView.findViewById(R.id.ivPrint);
            chip = itemView.findViewById(R.id.Chip);
            tvView = itemView.findViewById(R.id.tvView);
            tvReservationId = itemView.findViewById(R.id.tvOrderId);
        }
    }

    protected static class OrderStatusHeaderViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTitle;

        public OrderStatusHeaderViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
        }
    }
}
