package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.iarcuschin.simpleratingbar.SimpleRatingBar;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListener;
import com.tiffintom.partner1.models.LatestReviewModel;

import java.util.ArrayList;

public class ReviewAdapter extends RecyclerView.Adapter<ReviewAdapter.ViewHolder> {
    private Activity activity;
    private ArrayList<Object> reviewList;
    private RecyclerItemViewClickListener itemViewClickListener;

    public ReviewAdapter(Activity activity, ArrayList<Object> reviewList, RecyclerItemViewClickListener itemViewClickListener) {
        this.activity = activity;
        this.reviewList = reviewList;
        this.itemViewClickListener = itemViewClickListener;
    }

    @NonNull
    @Override
    public ReviewAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.review_list_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ReviewAdapter.ViewHolder holder, int position) {
        LatestReviewModel reviewModel = (LatestReviewModel) reviewList.get(position);

        holder.tvName.setText(reviewModel.first_name);
        holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(reviewModel.created, "yyyy-MM-dd", "dd/MM/yyyy"));
        holder.tvRatings.setText(new StringBuilder().append(Float.parseFloat(reviewModel.rating)).append("/5").toString());
        holder.ratingBar.setRating(Float.parseFloat(reviewModel.rating));
        holder.tvMakeResponce.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);

        if (!Validators.isNullOrEmpty(reviewModel.message)) {
            holder.llMessage.setVisibility(View.VISIBLE);
            holder.tvMessage.setText(reviewModel.message);
        } else {
            holder.llMessage.setVisibility(View.GONE);
        }
        if (!Validators.isNullOrEmpty(reviewModel.responce)) {
            holder.llResponce.setVisibility(View.VISIBLE);
            holder.tvResponce.setText(reviewModel.responce);
            holder.llMakeResponce.setBackgroundColor(Color.parseColor("#3C3C3C"));
            holder.tvMakeResponce.setText("Edit response");
        } else {
            holder.llMakeResponce.setBackgroundColor(Color.parseColor("#01A299"));
            holder.llResponce.setVisibility(View.GONE);
            holder.tvMakeResponce.setText("Respond");
        }
        holder.llMakeResponce.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (itemViewClickListener != null) {
                    itemViewClickListener.onItemClick(v, position, reviewModel);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return reviewList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName, tvDate, tvMessage, tvResponce, tvRatings, tvMakeResponce;
        private LinearLayout llResponce, llMessage, llMakeResponce;
        private SimpleRatingBar ratingBar;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvMessage = itemView.findViewById(R.id.tvMessage);
            tvResponce = itemView.findViewById(R.id.tvResponce);
            tvRatings = itemView.findViewById(R.id.tvRating);
            tvMakeResponce = itemView.findViewById(R.id.tvMakeRespones);
            ratingBar = itemView.findViewById(R.id.rating);
            llResponce = itemView.findViewById(R.id.llResponce);
            llMessage = itemView.findViewById(R.id.llMessage);
            llMakeResponce = itemView.findViewById(R.id.llMakeResponce);
        }
    }
}
