package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.SchedulePayment;

import java.util.ArrayList;


public class ScheduledPaymentViewPagerAdapter extends PagerAdapter {

    private LayoutInflater layoutInflater;
    private Activity activity;
    private ArrayList<SchedulePayment> payments;

    public ScheduledPaymentViewPagerAdapter(Activity activity, ArrayList<SchedulePayment> payments) {
        this.activity = activity;
        this.payments = payments;
    }

    @Override
    public int getCount() {
        return payments.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        layoutInflater = (LayoutInflater) activity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = layoutInflater.inflate(R.layout.scheduled_payment_items, null);
        TextView tvTitle = view.findViewById(R.id.tvTitle);
        TextView tvDate = view.findViewById(R.id.tvDate);
        TextView tvWeekRange = view.findViewById(R.id.tvWeekRange);

        SchedulePayment schedulePayment = payments.get(position);
        tvDate.setText(CommonFunctions.formatUnknownDateTime(schedulePayment.scheduleDate, "yyyy-MM-dd", "dd/MM/yyyy"));
        tvTitle.setText(schedulePayment.title);
        tvWeekRange.setText(CommonFunctions.formatUnknownDateTime(schedulePayment.weekFrom, "yyyy-MM-dd", "dd/MM") + " - " + CommonFunctions.formatUnknownDateTime(schedulePayment.weekTo, "yyyy-MM-dd", "dd/MM"));

        container.addView(view);
        return view;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        ViewPager vp = (ViewPager) container;
        View view = (View) object;
        vp.removeView(view);
    }
}
