package com.tiffintom.partner1.adapters;

import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.SubAddon;

import java.util.ArrayList;

public class SubAddonListAdapter extends RecyclerView.Adapter<SubAddonListAdapter.ViewHolder> {
    private ArrayList<SubAddon> subAddon;
    private RecyclerViewItemClickListener requiredClickListener, editClickListener;

    public SubAddonListAdapter(ArrayList<SubAddon> variant, RecyclerViewItemClickListener editClickListener, RecyclerViewItemClickListener requiredClickListener) {
        this.subAddon = variant;
        this.requiredClickListener = requiredClickListener;
        this.editClickListener = editClickListener;
    }


    @NonNull
    @Override
    public SubAddonListAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_multiple_products, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        SubAddon subAddon = this.subAddon.get(position);
        holder.tvVariants.setText(subAddon.subaddons_name);

        //subAddon.position = position;

        holder.checkBox.setOnCheckedChangeListener((compoundButton, b) -> {
            subAddon.status = holder.checkBox.isChecked();
            if (requiredClickListener != null) {
                requiredClickListener.onItemClick(position, subAddon);
            }
        });
        holder.tvEdit.setOnClickListener(view -> {
            if (editClickListener != null) {
                editClickListener.onItemClick(position, subAddon);
            }
        });
    }

    @Override
    public int getItemCount() {
        return subAddon.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llVarients, llRequired;
        private TextView tvVariants, tvPrice, tvEdit;
        private AppCompatCheckBox checkBox;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llVarients = itemView.findViewById(R.id.ll_PriceVariants);
            llRequired = itemView.findViewById(R.id.llRequired);
            tvVariants = itemView.findViewById(R.id.tvVariants);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvEdit = itemView.findViewById(R.id.tvEdit);
            checkBox = itemView.findViewById(R.id.cbRequired);
            tvPrice.setVisibility(View.INVISIBLE);
            llRequired.setVisibility(View.GONE);

            tvEdit.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
        }
    }
}
