package com.tiffintom.partner1.adapters;

import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.SubAddon;

import java.util.ArrayList;

public class SubVarientListAdapter extends RecyclerView.Adapter<SubVarientListAdapter.ViewHolder> {
    private ArrayList<SubAddon> subAddon;
    private RecyclerViewItemClickListener itemClickListener, editClickListener;

    public SubVarientListAdapter(ArrayList<SubAddon> variant, RecyclerViewItemClickListener editClickListener, RecyclerViewItemClickListener itemClickListener) {
        this.subAddon = variant;
        this.itemClickListener = itemClickListener;
        this.editClickListener = editClickListener;
    }


    @NonNull
    @Override
    public SubVarientListAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_multiple_products, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        SubAddon subAddon = this.subAddon.get(position);
        holder.tvVariants.setText(subAddon.subaddons_name);
        holder.tvPrice.setText(subAddon.subaddons_price);

        holder.checkBox.setChecked(subAddon.selected);
        holder.checkBox.setOnCheckedChangeListener((compoundButton, b) -> {
            subAddon.selected = holder.checkBox.isChecked();
            if (itemClickListener != null) {
                itemClickListener.onItemClick(position, subAddon);
            }
        });
        holder.tvEdit.setOnClickListener(view -> {
            if (editClickListener != null) {
                editClickListener.onItemClick(position, subAddon);
            }
        });
    }

    @Override
    public int getItemCount() {
        return subAddon.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llVarients;
        private TextView tvVariants, tvPrice, tvEdit;
        private AppCompatCheckBox checkBox;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llVarients = itemView.findViewById(R.id.ll_PriceVariants);
            tvVariants = itemView.findViewById(R.id.tvVariants);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvEdit = itemView.findViewById(R.id.tvEdit);
            checkBox = itemView.findViewById(R.id.cbRequired);

            tvEdit.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
        }
    }
}
