package com.tiffintom.partner1.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.SurChargesModel;

import java.util.ArrayList;

public class SurChargesAdapter extends RecyclerView.Adapter<SurChargesAdapter.AllergiesViewHolder> {

    private ArrayList<SurChargesModel> surChargesArrayList;
    private Context activity;
    private RecyclerViewItemClickListener recyclerViewItemClickListener;

    public SurChargesAdapter(Context activity, ArrayList<SurChargesModel> cuisineArrayList, RecyclerViewItemClickListener recyclerViewItemClickListener) {
        this.activity = activity;
        this.surChargesArrayList = cuisineArrayList;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public AllergiesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AllergiesViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.sur_charges_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull AllergiesViewHolder holder, int position) {

        SurChargesModel surChargesModel = surChargesArrayList.get(position);
        holder.tvChargeTitle.setText(surChargesModel.surcharge_name);
        if(surChargesModel.surcharge_amount>0){
            holder.tvChargeValue.setText(String.format("%s%s", MyApp.getInstance().getCurrencySymbol(), MyApp.df.format(surChargesModel.surcharge_amount)));
        }
    }

    @Override
    public int getItemCount() {
        return surChargesArrayList.size();
    }

    public class AllergiesViewHolder extends RecyclerView.ViewHolder {
        private TextView tvChargeTitle,tvChargeValue;
        public AllergiesViewHolder(@NonNull View itemView) {
            super(itemView);
            tvChargeTitle = itemView.findViewById(R.id.tvChargeTitle);
            tvChargeValue = itemView.findViewById(R.id.tvChargeValue);
        }
    }
}
