package com.tiffintom.partner1.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Header;
import com.tiffintom.partner1.models.MerchantCardTransaction;
import com.tiffintom.partner1.models.MerchantStatement;
import com.tiffintom.partner1.models.PaymentLink;
import com.tiffintom.partner1.models.TransactionModel;

import java.util.ArrayList;


public class TransactionsAndStatementsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements StickHeaderItemDecoration.StickyHeaderInterface {
    private Activity activity;
    private ArrayList<Object> items;
    private RecyclerViewItemClickListener viewItemClickListener, downloadItemClickListener, archiveSelectionClickListener, printClickListener;
    public boolean showCheck = false,isFromQRCode=false;
    private int merchantRole = MyApp.getInstance().getMyPreferences().getMerchantRole();

    public TransactionsAndStatementsAdapter(Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener viewItemClickListener, RecyclerViewItemClickListener downloadItemClickListener) {
        this.activity = activity;
        this.items = items;
        this.viewItemClickListener = viewItemClickListener;
        this.downloadItemClickListener = downloadItemClickListener;
    }

    public TransactionsAndStatementsAdapter(Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener viewItemClickListener, RecyclerViewItemClickListener downloadItemClickListener, RecyclerViewItemClickListener printClickListener) {
        this.activity = activity;
        this.items = items;
        this.viewItemClickListener = viewItemClickListener;
        this.downloadItemClickListener = downloadItemClickListener;
        this.printClickListener = printClickListener;
    }

    public TransactionsAndStatementsAdapter(Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener archiveSelectionClickListener) {
        this.activity = activity;
        this.items = items;
        this.archiveSelectionClickListener = archiveSelectionClickListener;
    }

    public TransactionsAndStatementsAdapter(boolean isFromQRCode,Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener archiveSelectionClickListener) {
        this.activity = activity;
        this.isFromQRCode = isFromQRCode;
        this.items = items;
        this.archiveSelectionClickListener = archiveSelectionClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (items.get(position) instanceof MerchantStatement) {
            return R.layout.item_statment_list;
        } else if (items.get(position) instanceof TransactionModel) {
            return R.layout.item_recent_transactions;
        } else if (items.get(position) instanceof MerchantCardTransaction) {
            return R.layout.item_merchant_transaction;
        } else if (items.get(position) instanceof PaymentLink) {
            return R.layout.item_payment_link;
        } else return R.layout.item_statement_month_header;

    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        if (viewType == R.layout.item_statment_list) {
            return new StatementViewHolder(view);
        } else if (viewType == R.layout.item_recent_transactions) {
            return new TransactionViewHolder(view);
        } else if (viewType == R.layout.item_merchant_transaction) {
            return new MerchantTransactionViewHolder(view);
        } else if (viewType == R.layout.item_payment_link) {
            return new PaymentLinksViewHolder(view);
        } else {
            return new MonthViewHolder(view);
        }

    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (getItemViewType(position) == R.layout.item_statment_list) {
            StatementViewHolder viewHolder = (StatementViewHolder) holder;
            MerchantStatement merchantStatement = (MerchantStatement) items.get(position);
            viewHolder.tvDate.setText("#" + merchantStatement.id + "\n" + CommonFunctions.formatUnknownDateTime(merchantStatement.to_date, "yyyy-MM-dd", "dd MMM yyyy"));
            viewHolder.tvViewStatment.setOnClickListener(view -> {
                if (viewItemClickListener != null) {
                    viewItemClickListener.onItemClick(position, merchantStatement);
                }
            });
            viewHolder.tvDownload.setOnClickListener(view -> {
                if (downloadItemClickListener != null) {
                    downloadItemClickListener.onItemClick(position, merchantStatement);
                }
            });
        }
        if (getItemViewType(position) == R.layout.item_recent_transactions) {
            TransactionModel transactionModel = (TransactionModel) items.get(position);
            TransactionViewHolder viewHolder = (TransactionViewHolder) holder;
            viewHolder.tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + transactionModel.total);
            viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(transactionModel.payment_date, MyApp.PHP_TIMEFORMAT, "EEE dd/MM"));
            if (transactionModel.status.equalsIgnoreCase("refunded")) {
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_remove_24);
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.red));
                viewHolder.tvBrand.setText(transactionModel.status);
            } else {
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.persian_green));
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_add_24);
                if (transactionModel.payment_type.equalsIgnoreCase("stripe")) {
                    viewHolder.tvBrand.setText(transactionModel.brand);
                } else {
                    viewHolder.tvBrand.setText(transactionModel.payment_type);
                }
            }

            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            layoutParams.setMargins(CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8), CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8));
            viewHolder.llMain.setLayoutParams(layoutParams);
            if (showCheck) {
                viewHolder.rbChecked.setVisibility(View.VISIBLE);
                viewHolder.rbChecked.setChecked(transactionModel.checked);

                viewHolder.llMain.setOnClickListener(view -> {
                    transactionModel.checked = !transactionModel.checked;
                    viewHolder.rbChecked.setChecked(transactionModel.checked);
                    if (archiveSelectionClickListener != null)
                        archiveSelectionClickListener.onItemClick(position, transactionModel);
                });
            } else {
                viewHolder.rbChecked.setVisibility(View.GONE);
            }

        }
        if (getItemViewType(position) == R.layout.item_merchant_transaction) {
            MerchantCardTransaction merchantTransaction = (MerchantCardTransaction) items.get(position);
            MerchantTransactionViewHolder viewHolder = (MerchantTransactionViewHolder) holder;
            viewHolder.tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + merchantTransaction.amount);
//            viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(merchantTransaction.created_at, "HH:mm", "hh:mm a"));
            if (!Validators.isNullOrEmpty(merchantTransaction.transaction_date_time))
                viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(merchantTransaction.transaction_date_time, MyApp.PHP_TIMEFORMAT, "dd MMM, hh:mm a"));
            else {
                viewHolder.tvDate.setText(CommonFunctions.formatMiliToDesireFormat(Long.parseLong(merchantTransaction.created + "000"), "dd MMM, hh:mm a"));
            }
            viewHolder.tvType.setText(merchantTransaction.type);

            if (merchantTransaction.type.equalsIgnoreCase("charge")) {
                if (merchantTransaction.status.equalsIgnoreCase("failed")) {
                    viewHolder.tvBrand.setText("Failed");
                    viewHolder.btnRefund.setVisibility(View.GONE);
                } else {
                    viewHolder.tvBrand.setVisibility(View.VISIBLE);
                    viewHolder.btnRefund.setVisibility(View.VISIBLE);
                    if (merchantTransaction.card_type.equalsIgnoreCase("card")) {
                        viewHolder.tvBrand.setText(merchantTransaction.card_brand);
                    } else {
                        viewHolder.tvBrand.setText(merchantTransaction.card_type);
                    }
                }
                if (merchantRole == 2 && MyApp.getInstance().getMyPreferences().getMerchantBusinesses().admin_permissions.refund) {
                    viewHolder.btnRefund.setVisibility(View.VISIBLE);
                    viewHolder.btnPrint.setVisibility(View.VISIBLE);
                } else if (merchantRole == 1 && MyApp.getInstance().getMyPreferences().getMerchantBusinesses().supervisor_permissions.refund) {
                    viewHolder.btnRefund.setVisibility(View.VISIBLE);
                    viewHolder.btnPrint.setVisibility(View.VISIBLE);
                } else {
                    viewHolder.btnRefund.setVisibility(View.GONE);
                    viewHolder.btnPrint.setVisibility(View.VISIBLE);
                }
            } else if (merchantTransaction.type.equalsIgnoreCase("paypal")) {
                viewHolder.tvBrand.setVisibility(View.GONE);
                viewHolder.btnRefund.setVisibility(View.GONE);
                viewHolder.btnPrint.setVisibility(View.GONE);
            } else {
                viewHolder.tvBrand.setVisibility(View.GONE);
                viewHolder.btnRefund.setVisibility(View.GONE);
                viewHolder.btnPrint.setVisibility(View.GONE);
            }


            viewHolder.btnRefund.setOnClickListener(view -> {
                if (downloadItemClickListener != null) {
                    downloadItemClickListener.onItemClick(position, merchantTransaction);
                }
            });
            viewHolder.btnPrint.setOnClickListener(view -> {
                if (printClickListener != null) {
                    printClickListener.onItemClick(position, merchantTransaction);
                }
            });

            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            layoutParams.setMargins(CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8), CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8));
            viewHolder.llMain.setLayoutParams(layoutParams);
            if (showCheck) {
                viewHolder.rbChecked.setVisibility(View.VISIBLE);
                viewHolder.rbChecked.setChecked(merchantTransaction.checked);

                viewHolder.llMain.setOnClickListener(view -> {
                    merchantTransaction.checked = !merchantTransaction.checked;
                    viewHolder.rbChecked.setChecked(merchantTransaction.checked);
                    if (viewItemClickListener != null)
                        viewItemClickListener.onItemClick(position, merchantTransaction);
                });
            } else {
                viewHolder.rbChecked.setVisibility(View.GONE);
            }

        }
        if (getItemViewType(position) == R.layout.item_payment_link) {
            PaymentLink paymentLink = (PaymentLink) items.get(position);
            PaymentLinksViewHolder viewHolder = (PaymentLinksViewHolder) holder;
            viewHolder.tvAmount.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(paymentLink.amount));
            viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(paymentLink.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "dd MMM hh:mm a"));
            viewHolder.tvStatus.setText(paymentLink.status);
            viewHolder.tvPhone.setText(paymentLink.phone);
            viewHolder.btnResend.setVisibility(View.GONE);
            if (paymentLink.status.equalsIgnoreCase("failed")) {
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_remove_24);
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.red));
            } else if (paymentLink.status.equalsIgnoreCase("pending")) {
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_access_time_24);
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.orders_card_bg_orange));
                viewHolder.btnResend.setVisibility(View.VISIBLE);
            } else {
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.persian_green));
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_green_done_24);
            }
            viewHolder.btnResend.setOnClickListener(view -> {
                if (archiveSelectionClickListener != null) {
                    archiveSelectionClickListener.onItemClick(position, paymentLink);
                }
            });
            if(isFromQRCode){
                viewHolder.btnResend.setText("Show");
            }
//            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
//            layoutParams.setMargins(CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8), CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8));
//            viewHolder.llMain.setLayoutParams(layoutParams);
//

        }
        if (getItemViewType(position) == R.layout.item_statement_month_header) {
            MonthViewHolder header = (MonthViewHolder) holder;
            Header indicatorHeader = (Header) items.get(position);
            header.tvMonth.setText(indicatorHeader.title);
            if (!Validators.isNullOrEmpty(indicatorHeader.total)) {
                header.tvTotal.setVisibility(View.VISIBLE);
                header.tvTotal.setText(MyApp.getInstance().getCurrencySymbol() + MyApp.df.format(Float.parseFloat(indicatorHeader.total)));
            } else {
                header.tvTotal.setVisibility(View.GONE);
            }
        }
    }


    @Override
    public int getItemCount() {
        return items.size();
    }

    @Override
    public int getHeaderPositionForItem(int itemPosition) {
        int headerPosition = -1;
        do {
            if (this.isHeader(itemPosition)) {
                headerPosition = itemPosition;
                break;
            }
            itemPosition -= 1;
        } while (itemPosition >= 0);
        return headerPosition;
    }


    @Override
    public int getHeaderLayout(int headerPosition) {
        return R.layout.item_statement_month_header;
    }

    @Override
    public void bindHeaderData(View header, int headerPosition) {
        if (items.get(headerPosition) instanceof Header) {
            TextView tvTitle = header.findViewById(R.id.tvMonth);
            TextView tvTotal = header.findViewById(R.id.tvTotal);
            Header indicatorHeader = (Header) items.get(headerPosition);
            tvTitle.setText(indicatorHeader.title);
            if (!Validators.isNullOrEmpty(indicatorHeader.total)) {
                tvTotal.setVisibility(View.VISIBLE);
                tvTotal.setText(MyApp.getInstance().getCurrencySymbol() + indicatorHeader.total);
            } else {
                tvTotal.setVisibility(View.GONE);
            }
        }
    }

    @Override
    public boolean isHeader(int itemPosition) {
        return getItemViewType(itemPosition) == R.layout.item_statement_month_header;
    }

    protected static class StatementViewHolder extends RecyclerView.ViewHolder {
        private TextView tvDate, tvViewStatment, tvDownload;

        public StatementViewHolder(@NonNull View itemView) {
            super(itemView);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvViewStatment = itemView.findViewById(R.id.tvViewStatment);
            tvDownload = itemView.findViewById(R.id.tvDownload);
        }
    }


    private static class MonthViewHolder extends RecyclerView.ViewHolder {
        TextView tvMonth, tvTotal;

        public MonthViewHolder(View view) {
            super(view);
            tvMonth = view.findViewById(R.id.tvMonth);
            tvTotal = view.findViewById(R.id.tvTotal);
        }
    }

    protected static class TransactionViewHolder extends RecyclerView.ViewHolder {
        private TextView tvBrand, tvDate, tvAmount;
        private ImageView ivEntry;
        private LinearLayout llMain;
        private RadioButton rbChecked;

        public TransactionViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBrand = itemView.findViewById(R.id.tvBrand);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            llMain = itemView.findViewById(R.id.llMainLayout);
            rbChecked = itemView.findViewById(R.id.rbChecked);

        }
    }

    protected static class MerchantTransactionViewHolder extends RecyclerView.ViewHolder {
        private TextView tvBrand, tvDate, tvAmount, tvType;
        private ImageView ivEntry;
        private LinearLayout llMain;
        private RadioButton rbChecked;
        private MaterialButton btnRefund, btnPrint;

        public MerchantTransactionViewHolder(@NonNull View itemView) {
            super(itemView);
            btnRefund = itemView.findViewById(R.id.btnRefund);
            btnPrint = itemView.findViewById(R.id.btnPrint);
            tvBrand = itemView.findViewById(R.id.tvBrand);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvType = itemView.findViewById(R.id.tvType);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            llMain = itemView.findViewById(R.id.llMainLayout);
            rbChecked = itemView.findViewById(R.id.rbChecked);

        }
    }

    protected static class PaymentLinksViewHolder extends RecyclerView.ViewHolder {
        private TextView tvStatus, tvDate, tvAmount, tvPhone;
        private MaterialButton btnResend;
        private ImageView ivEntry;
        private LinearLayout llMain;

        public PaymentLinksViewHolder(@NonNull View itemView) {
            super(itemView);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            tvStatus = itemView.findViewById(R.id.tvStatus);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            llMain = itemView.findViewById(R.id.llMainLayout);
            btnResend = itemView.findViewById(R.id.btnResend);
            tvPhone = itemView.findViewById(R.id.tvPhone);

        }
    }
}
