package com.tiffintom.partner1.base;

import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.sunmi.sunmi_utils.BluetoothUtil;
import com.sunmi.sunmi_utils.ESCUtil;
import com.sunmi.sunmi_utils.SunmiPrintHelper;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.utils.LogUtils;

/**
 * Created by admin on 14-03-2017.
 */

public class BaseActivity extends AppCompatActivity {

    protected MyApp myApp = MyApp.getInstance();
    protected AlertDialog progressDialog;
    protected RestaurantUser loggedInRestaurant;
    protected Merchant loggedInMerchant;
    protected MerchantBusinesses merchantBusinesses;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        manageIntents();
        setXML();
        initViews();
        initPrinterStyle();
    }

    protected void manageIntents() {
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                LogUtils.w("##EXTRAS##", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
            }
        }
    }

    protected void setXML() {

    }

    protected void initViews() {
        loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
        loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
        merchantBusinesses = myApp.getMyPreferences().getMerchantBusinesses();
        if (loggedInMerchant != null && merchantBusinesses != null && !merchantBusinesses.merchant_service)
            loggedInMerchant = null;
        if (loggedInMerchant != null && merchantBusinesses == null) loggedInMerchant = null;
        progressDialog = CommonFunctions.customProgressDialog(this, "Loading...");
    }

    /**
     * Initialize the printer
     * All style settings will be restored to default
     */
    private void initPrinterStyle() {
        if (BluetoothUtil.isBlueToothPrinter) {
            BluetoothUtil.sendData(ESCUtil.init_printer());
        } else {
            SunmiPrintHelper.getInstance().initPrinter();
        }
    }

    @Override
    public boolean onSupportNavigateUp() {
        onBackPressed();
        return super.onSupportNavigateUp();
    }

}
