package com.tiffintom.partner1.base;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.utils.LogUtils;

/**
 * Created by admin on 22-01-2018.
 */

public class BaseFragment extends Fragment {

    protected MyApp myApp = MyApp.getInstance();
    protected AlertDialog progressDialog;
    protected RestaurantUser loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
    protected Merchant loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
    protected MerchantBusinesses merchantBusiness = myApp.getMyPreferences().getMerchantBusinesses();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        manageIntents();
        initViews(view);
    }

    protected void manageIntents() {
        Bundle bundle = getArguments();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                LogUtils.w("##EXTRAS##", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
            }
        }
    }

    protected void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity(), "Loading...");
        if (merchantBusiness != null && !merchantBusiness.merchant_service) loggedInMerchant = null;
    }


}
