package com.tiffintom.partner1.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Address;
import android.location.Geocoder;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.android.material.snackbar.Snackbar;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.models.TransactionReasonModel;
import com.tiffintom.partner1.models.User;
import com.tiffintom.partner1.utils.Constants;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class CommonFunctions {
    public static DecimalFormat df = new DecimalFormat("#.##");

    public static ArrayList<TransactionReasonModel> getTransactionReason() {
        ArrayList<TransactionReasonModel> transactionReasonModels = new ArrayList<>();
        transactionReasonModels.add(new TransactionReasonModel("Emigration","Emigrating"));
        transactionReasonModels.add(new TransactionReasonModel("Gifting","Gifting or loaning money to family member"));
        transactionReasonModels.add(new TransactionReasonModel("Inheritance","Inheritance"));
        transactionReasonModels.add(new TransactionReasonModel("Investments","Making or selling overseas investments"));
        transactionReasonModels.add(new TransactionReasonModel("Expenditure","Moving money between own accounts for general expenditure"));
        transactionReasonModels.add(new TransactionReasonModel("Expenses","Overseas medical expenses"));
        transactionReasonModels.add(new TransactionReasonModel("HolidayExpenses","Paying for holiday accommodation or other holiday related expenses"));
        transactionReasonModels.add(new TransactionReasonModel("BillPays","Paying overseas bills"));
        transactionReasonModels.add(new TransactionReasonModel("Taxes","Paying overseas tax"));
        transactionReasonModels.add(new TransactionReasonModel("Property","Property purchase/sale"));
        transactionReasonModels.add(new TransactionReasonModel("Pension","Receiving pension"));
        transactionReasonModels.add(new TransactionReasonModel("Employment","Receiving salary for overseas employment"));
        transactionReasonModels.add(new TransactionReasonModel("Weddings","Weddings"));
        transactionReasonModels.add(new TransactionReasonModel("Others","Other"));
        return transactionReasonModels;
    }
    public static BigDecimal formatTo2Digit(float value) {
        BigDecimal bd = new BigDecimal(value);
        bd.setScale(2, BigDecimal.ROUND_HALF_UP);
        bd = bd.setScale(2, BigDecimal.ROUND_HALF_UP);
        return bd;
    }

    public static BigDecimal formatTo2DigitBigDecimal(BigDecimal value) {
        BigDecimal bd = value;
        bd.setScale(2, BigDecimal.ROUND_HALF_UP);
        bd = bd.setScale(2, BigDecimal.ROUND_HALF_UP);
        return bd;
    }

    public static AlertDialog customProgressDialog(Context context, String title) {
        AlertDialog alertDialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View dialogView = inflater.inflate(R.layout.progress_dialog_layout, null);

        TextView tvMessage = dialogView.findViewById(R.id.tvMessage);
        if (!Validators.isNullOrEmpty(title)) {
            tvMessage.setText(title);
        }

        builder.setView(dialogView);
        builder.setCancelable(false);
        alertDialog = builder.create();
        alertDialog.getWindow().getDecorView().setBackgroundResource(android.R.color.transparent);
        alertDialog.getWindow().setDimAmount(0.0f);
        return alertDialog;
    }

    public static String StringAppender(String... s) {
        StringBuilder builder = new StringBuilder();
        for (String string : s) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static JSONArray convertToJSONArray(ResultSet resultSet)
            throws Exception {
        JSONArray jsonArray = new JSONArray();
        while (resultSet.next()) {
            int total_columns = resultSet.getMetaData().getColumnCount();
            JSONObject obj = new JSONObject();
            for (int i = 0; i < total_columns; i++) {
                obj.put(resultSet.getMetaData().getColumnLabel(i + 1).toLowerCase(), resultSet.getObject(i + 1));
            }
            jsonArray.put(obj);
        }
        return jsonArray;
    }

    public static String md5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (byte b : messageDigest) {
                hexString.append(Integer.toHexString(b & 255));
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static void hideKeyboard(Activity activity, View view) {
        try {
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void openKeyboard(Activity activity, View view) {
        try {
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
            imm.toggleSoftInputFromWindow(view.getWindowToken(), InputMethodManager.SHOW_FORCED, 0);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static String convertMsToDesiredFormat(long ms, String dateFormat) {
        DateFormat outputFormat = new SimpleDateFormat(dateFormat, Locale.getDefault());
        Date outputDate = new Date(ms);
        return outputFormat.format(outputDate);
    }

    public static String formatUnknownDateTime(final String date, final String currentFormat, final String desireFormat) {

        DateFormat inputFormat = new SimpleDateFormat(currentFormat, Locale.getDefault());
        DateFormat outputFormat = new SimpleDateFormat(desireFormat, Locale.getDefault());

        String formattedDate = null;

        try {
            Date inputDate = inputFormat.parse(date);
            formattedDate = outputFormat.format(inputDate);
            Date outputDate = outputFormat.parse(formattedDate);
            if (desireFormat.equalsIgnoreCase("dd MMM yyyy")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("d'st' MMM yyyy").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("d'nd' MMM yyyy").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("d'rd' MMM yyyy").format(inputDate);
                        default:
                            return new SimpleDateFormat("d'th' MMM yyyy").format(inputDate);
                    }
                return new SimpleDateFormat("d'th' MMM yyyy").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("dd MMM")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("d'st' MMM").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("d'nd' MMM").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("d'rd' MMM").format(inputDate);
                        default:
                            return new SimpleDateFormat("d'th' MMM").format(inputDate);
                    }
                return new SimpleDateFormat("d'th' MMMM").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("EEE dd MMM")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("EEE d'st' MMM").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("EEE d'nd' MMM").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("EEE d'rd' MMM").format(inputDate);
                        default:
                            return new SimpleDateFormat("EEE d'th' MMM").format(inputDate);
                    }
                return new SimpleDateFormat("EEE d'th' MMM").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("EEE dd MMM, yyyy")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("EEE d'st' MMM, yyyy").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("EEE d'nd' MMM, yyyy").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("EEE d'rd' MMM, yyyy").format(inputDate);
                        default:
                            return new SimpleDateFormat("EEE d'th' MMM, yyyy").format(inputDate);
                    }
                return new SimpleDateFormat("EEE d'th' MMM, yyyy").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("EEE dd MMM 'at' hh:mm a")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("EEE d'st' MMM 'at' hh:mm a").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("EEE d'nd' MMM 'at' hh:mm a").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("EEE d'rd' MMM 'at' hh:mm a").format(inputDate);
                        default:
                            return new SimpleDateFormat("EEE d'th' MMM 'at' hh:mm a").format(inputDate);
                    }
                return new SimpleDateFormat("EEE d'th' MMM 'at' hh:mm a").format(inputDate);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return formattedDate;
    }

    public static long formatTimezoneTimestampAndGetMs(final String timestamp) {

        DateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'hhmmssZ", Locale.getDefault());

        Date formattedDate = null;
        try {
            formattedDate = inputFormat.parse(timestamp);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (formattedDate == null) return 0;
        else return formattedDate.getTime();
    }


    public static String formatTimestamp(final String timestamp, final String desireFormat) {

        DateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSSSS'Z'", Locale.getDefault());
        DateFormat outputFormat = new SimpleDateFormat(desireFormat, Locale.getDefault());

        String formattedDate = null;

        try {
            formattedDate = outputFormat.format(inputFormat.parse(timestamp));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return formattedDate;
    }

    public static String formatMiliToDesireFormat(final long timestamp, final String desireFormat) {

        DateFormat outputFormat = new SimpleDateFormat(desireFormat, Locale.getDefault());

        String formattedDate = null;

        formattedDate = outputFormat.format(timestamp);

        return formattedDate;
    }

    public static Date convertStringDateToDate(String date, String inputFormat) {
        DateFormat format = new SimpleDateFormat(inputFormat, Locale.getDefault());
        Date formattedDate = new Date();
        try {
            formattedDate = format.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return formattedDate;
    }

    static Date todayDate = CommonFunctions.convertStringDateToDate(CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy"), "dd-MM-yyyy");

    public static boolean isPreOrder(String orderDeliveryDate, String status) {
        Date orderDate = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(orderDeliveryDate.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy"), "dd-MM-yyyy");
        if (status.equalsIgnoreCase("pending") && orderDate.after(todayDate)) {
            return true;
        } else return false;
    }

    public static boolean isPreOrderNew(String orderDeliveryDate, String status) {
        Date orderDate = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(orderDeliveryDate, "yyyy-MM-dd", "dd-MM-yyyy"), "dd-MM-yyyy");
        if (orderDate.before(todayDate) || orderDate.equals(todayDate)) {
            return false;
        } else {
            if (status.equalsIgnoreCase("pending")) {
                return true; // For Pre order
            } else {
                return false;
            }
        }
    }

    public static boolean isPreOrderWithoutStatus(String orderDeliveryDate) {
        Date orderDate = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(orderDeliveryDate, "yyyy-MM-dd", "dd-MM-yyyy"), "dd-MM-yyyy");
        if (orderDate.before(todayDate) || orderDate.equals(todayDate)) {
            return true;
        } else return false;
    }

    public static int getProfilePercentage(User user) {
        int progress = 0;

        if (!Validators.isNullOrEmpty(user.customerDetails.first_name)) {
            progress = progress + 20;
        }
        if (!Validators.isNullOrEmpty(user.customerDetails.last_name)) {
            progress = progress + 20;
        }
        if (!Validators.isNullOrEmpty(user.customerDetails.phone_number)) {
            progress = progress + 20;
        }
        if (!Validators.isNullOrEmpty(user.customerDetails.username)) {
            progress = progress + 20;
        }
        if (!Validators.isNullOrEmpty(user.customerDetails.image)) {
            progress = progress + 20;
        }
        return progress;
    }

    public static Address getAddressByLocation(Context ctx, double latitude, double longitude) {
        StringBuilder result = new StringBuilder();
        try {
            Geocoder geocoder = new Geocoder(ctx, Locale.getDefault());
            List<Address>
                    addresses = geocoder.getFromLocation(latitude, longitude, 1);
            if (addresses != null && addresses.size() > 0) {
                return addresses.get(0);
            }
        } catch (IOException e) {
            Log.e("tag", e.getMessage());
        }
        return null;
    }


    public static String getTodayDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getDisplayName(Calendar.DAY_OF_WEEK, Calendar.LONG, Locale.getDefault());
    }

    public static String getCurrentTimeFormatted(String desiredFormat) {
        DateFormat outputFormat = new SimpleDateFormat(desiredFormat, Locale.getDefault());
        Date date = new Date();
        return outputFormat.format(date);
    }

    public static void notifyCartCount(Context context) {
        Intent cartBroadcast = new Intent(Constants.CART_UPDATE);
        cartBroadcast.putExtra("update_cart_count", true);
        LocalBroadcastManager.getInstance(context).sendBroadcast(cartBroadcast);
    }

    public static void notifyOnNetChange(Context context) {
        Intent cartBroadcast = new Intent(Constants.NET_UPDATE);
        cartBroadcast.putExtra("net_update", true);
        LocalBroadcastManager.getInstance(context).sendBroadcast(cartBroadcast);
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();

        return activeNetwork != null && activeNetwork.isConnected();
    }

    public static String getOrderType(int type) {
        if (type == 0) {
            return "Dine in";
        } else if (type == 1) {
            return "Delivery";
        } else if (type == 2) {
            return "Pickup";
        } else
            return "";
    }

    public static int pxToDp(Context context, int dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, context.getResources().getDisplayMetrics());
    }

    public static String PerfectDecimal(String str, int MAX_BEFORE_POINT, int MAX_DECIMAL) {
        if (str.charAt(0) == '.') str = "0" + str;
        int max = str.length();

        String rFinal = "";
        boolean after = false;
        int i = 0, up = 0, decimal = 0;
        char t;
        while (i < max) {
            t = str.charAt(i);
            if (t != '.' && !after) {
                up++;
                if (up > MAX_BEFORE_POINT) return rFinal;
            } else if (t == '.') {
                after = true;
            } else {
                decimal++;
                if (decimal > MAX_DECIMAL)
                    return rFinal;
            }
            rFinal = rFinal + t;
            i++;
        }
        return rFinal;
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message, int length, int color) {
        Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, length);
        greySnackBar.setBackgroundTint(ContextCompat.getColor(context, color));
        greySnackBar.show();
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message, int length) {
        Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, length);
        greySnackBar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
        greySnackBar.show();
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message) {
        if (coordinatorLayout != null) {
            Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, Snackbar.LENGTH_LONG);
            greySnackBar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
            greySnackBar.show();
        }
    }

    public static String getPreviousDate(String inputDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(inputDate);
            Calendar c = Calendar.getInstance();
            c.setTime(date);

            c.add(Calendar.DATE, days);
            inputDate = format.format(c.getTime());
            Log.d("asd", "selected date : " + inputDate);

            System.out.println(date);
        } catch (Exception e) {
            e.printStackTrace();
            inputDate = "";
        }
        return inputDate;
    }

    // Change 24 hour format to am or pm
    public static String convertTimeFormat(String timeInput) {
        String time = "";
        try {
            if (timeInput.toLowerCase().contains("am") || timeInput.toLowerCase().contains("pm")) {
                return timeInput;
            } else {
                String[] splitTime = timeInput.split(":");
                if (splitTime.length > 0) {
                    int hourOfDay = Integer.parseInt(splitTime[0]);
                    int minute = Integer.parseInt(splitTime[1]);
                    time = ((((hourOfDay % 12 == 0) ? "12" : ((hourOfDay % 12) > 9 ? (hourOfDay % 12) : "0" + (hourOfDay % 12))) + ":" + ((minute > 9) ? minute : ("0" + minute)) + " " + ((hourOfDay >= 12) ? "PM" : "AM")));
                    return time;
                } else {
                    return timeInput;
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
            return timeInput;
        }
    }

    public static void functionThatDelay(long ms) {
        try {
            Thread.sleep(ms);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

}
